/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.calendar.recurrence;

import com.google.ical.values.DateTimeValue;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import com.google.ical.values.RDateList;
import com.google.ical.values.RRule;
import com.google.ical.values.WeekdayNum;
import com.liferay.calendar.recurrence.Frequency;
import com.liferay.calendar.recurrence.PositionalWeekday;
import com.liferay.calendar.recurrence.Recurrence;
import com.liferay.calendar.recurrence.Weekday;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class RecurrenceSerializer {
    private static final String _EXDATE = "EXDATE";
    private static final Log _log = LogFactoryUtil.getLog(RecurrenceSerializer.class);
    private static final Map<Weekday, com.google.ical.values.Weekday> _weekdaysMap = HashMapBuilder.put((Object)((Object)Weekday.FRIDAY), (Object)com.google.ical.values.Weekday.FR).put((Object)Weekday.MONDAY, (Object)com.google.ical.values.Weekday.MO).put((Object)Weekday.SATURDAY, (Object)com.google.ical.values.Weekday.SA).put((Object)Weekday.SUNDAY, (Object)com.google.ical.values.Weekday.SU).put((Object)Weekday.THURSDAY, (Object)com.google.ical.values.Weekday.TH).put((Object)Weekday.TUESDAY, (Object)com.google.ical.values.Weekday.TU).put((Object)Weekday.WEDNESDAY, (Object)com.google.ical.values.Weekday.WE).build();

    public static Recurrence deserialize(String data, TimeZone timeZone) {
        if (Validator.isNull((String)data)) {
            return null;
        }
        try {
            Recurrence recurrence = new Recurrence();
            int index = data.indexOf(10);
            if (index != -1) {
                String exceptionDates = data.substring(index + 1);
                RDateList rDateList = new RDateList(exceptionDates, timeZone);
                for (DateValue dateValue : rDateList.getDatesUtc()) {
                    Calendar jCalendar = RecurrenceSerializer._toJCalendar(dateValue, timeZone);
                    recurrence.addExceptionJCalendar(jCalendar);
                }
                data = data.substring(0, index);
            }
            RRule rRule = new RRule(data);
            recurrence.setCount(rRule.getCount());
            recurrence.setFrequency(Frequency.parse(String.valueOf(rRule.getFreq())));
            recurrence.setInterval(rRule.getInterval());
            recurrence.setTimeZone(timeZone);
            DateValue dateValue = rRule.getUntil();
            if (dateValue != null) {
                Calendar jCalendar = RecurrenceSerializer._toJCalendar(dateValue, timeZone);
                recurrence.setUntilJCalendar(jCalendar);
            }
            ArrayList<PositionalWeekday> positionalWeekdays = new ArrayList<PositionalWeekday>();
            for (WeekdayNum weekdayNum : rRule.getByDay()) {
                Weekday weekday = Weekday.parse(weekdayNum.wday.toString());
                PositionalWeekday positionalWeekday = new PositionalWeekday(weekday, weekdayNum.num);
                positionalWeekdays.add(positionalWeekday);
            }
            recurrence.setPositionalWeekdays(positionalWeekdays);
            recurrence.setMonths(ListUtil.fromArray((int[])rRule.getByMonth()));
            return recurrence;
        }
        catch (ParseException parseException) {
            _log.error((Object)("Unable to parse data " + data), (Throwable)parseException);
            return null;
        }
    }

    public static String serialize(Recurrence recurrence) {
        if (recurrence == null) {
            return null;
        }
        RRule rRule = new RRule();
        ArrayList<WeekdayNum> weekdayNums = new ArrayList<WeekdayNum>();
        for (PositionalWeekday positionalWeekday : recurrence.getPositionalWeekdays()) {
            com.google.ical.values.Weekday wday = _weekdaysMap.get((Object)positionalWeekday.getWeekday());
            WeekdayNum weekdayNum = new WeekdayNum(positionalWeekday.getPosition(), wday);
            weekdayNums.add(weekdayNum);
        }
        rRule.setByDay(weekdayNums);
        List<Integer> months = recurrence.getMonths();
        if (months != null) {
            int[] monthsArray = ArrayUtil.toIntArray(months);
            int i = 0;
            while (i < monthsArray.length) {
                int n = i++;
                monthsArray[n] = monthsArray[n] + 1;
            }
            rRule.setByMonth(monthsArray);
        }
        rRule.setCount(recurrence.getCount());
        com.google.ical.values.Frequency frequency = com.google.ical.values.Frequency.valueOf((String)String.valueOf((Object)recurrence.getFrequency()));
        rRule.setFreq(frequency);
        rRule.setInterval(recurrence.getInterval());
        Calendar jCalendar = recurrence.getUntilJCalendar();
        if (jCalendar != null) {
            DateValue dateValue = RecurrenceSerializer._toDateValue(jCalendar);
            rRule.setUntil(dateValue);
        }
        String data = rRule.toIcal();
        List<Calendar> exceptionJCalendars = recurrence.getExceptionJCalendars();
        if (!exceptionJCalendars.isEmpty()) {
            DateValue[] dateValues = new DateValue[exceptionJCalendars.size()];
            for (int i = 0; i < exceptionJCalendars.size(); ++i) {
                dateValues[i] = RecurrenceSerializer._toDateValue(exceptionJCalendars.get(i));
            }
            RDateList rDateList = new RDateList(TimeZone.getTimeZone("UTC"));
            rDateList.setDatesUtc(dateValues);
            rDateList.setName(_EXDATE);
            data = StringBundler.concat((String[])new String[]{data, "\n", rDateList.toIcal()});
        }
        return data;
    }

    private static DateValue _toDateValue(Calendar jCalendar) {
        return new DateValueImpl(jCalendar.get(1), jCalendar.get(2) + 1, jCalendar.get(5));
    }

    private static Calendar _toJCalendar(DateValue dateValue, TimeZone timeZone) {
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (dateValue instanceof DateTimeValue) {
            DateTimeValue dateTimeValue = (DateTimeValue)dateValue;
            hour = dateTimeValue.hour();
            minute = dateTimeValue.minute();
            second = dateTimeValue.second();
        }
        return CalendarFactoryUtil.getCalendar((int)dateValue.year(), (int)(dateValue.month() - 1), (int)dateValue.day(), (int)hour, (int)minute, (int)second, (int)0, (TimeZone)timeZone);
    }
}

