/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.calendar.util;

import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.iter.RecurrenceIteratorFactory;
import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import com.liferay.calendar.model.CalendarBooking;
import com.liferay.calendar.recurrence.PositionalWeekday;
import com.liferay.calendar.recurrence.Recurrence;
import com.liferay.calendar.recurrence.Weekday;
import com.liferay.calendar.util.CalendarBookingIterator;
import com.liferay.calendar.util.JCalendarUtil;
import com.liferay.calendar.util.comparator.CalendarBookingStartTimeComparator;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.TimeZone;

public class RecurrenceUtil {
    private static final Log _log = LogFactoryUtil.getLog(RecurrenceUtil.class);

    public static List<CalendarBooking> expandCalendarBooking(CalendarBooking calendarBooking, long startTime, long endTime, int maxSize) {
        ArrayList<CalendarBooking> expandedCalendarBookings = new ArrayList<CalendarBooking>();
        try {
            CalendarBookingIterator calendarBookingIterator = new CalendarBookingIterator(calendarBooking);
            while (calendarBookingIterator.hasNext()) {
                CalendarBooking newCalendarBooking = calendarBookingIterator.next();
                if (newCalendarBooking.getEndTime() < startTime) continue;
                if (newCalendarBooking.getStartTime() <= endTime) {
                    expandedCalendarBookings.add(newCalendarBooking);
                    if (maxSize <= 0 || expandedCalendarBookings.size() < maxSize) continue;
                }
                break;
            }
        }
        catch (ParseException parseException) {
            _log.error((Object)"Unable to parse data ", (Throwable)parseException);
        }
        return expandedCalendarBookings;
    }

    public static List<CalendarBooking> expandCalendarBookings(List<CalendarBooking> calendarBookings, long startTime, long endTime) {
        return RecurrenceUtil.expandCalendarBookings(calendarBookings, startTime, endTime, 0);
    }

    public static List<CalendarBooking> expandCalendarBookings(List<CalendarBooking> calendarBookings, long startTime, long endTime, int maxSize) {
        ArrayList<CalendarBooking> expandedCalendarBookings = new ArrayList<CalendarBooking>();
        for (CalendarBooking calendarBooking : calendarBookings) {
            List<CalendarBooking> expandedCalendarBooking = RecurrenceUtil.expandCalendarBooking(calendarBooking, startTime, endTime, maxSize);
            expandedCalendarBookings.addAll(expandedCalendarBooking);
        }
        return expandedCalendarBookings;
    }

    public static CalendarBooking getCalendarBookingInstance(CalendarBooking calendarBooking, int instanceIndex) {
        try {
            CalendarBookingIterator calendarBookingIterator = new CalendarBookingIterator(calendarBooking);
            while (calendarBookingIterator.hasNext()) {
                CalendarBooking calendarBookingInstance = calendarBookingIterator.next();
                if (calendarBookingInstance.getInstanceIndex() != instanceIndex) continue;
                return calendarBookingInstance;
            }
        }
        catch (ParseException parseException) {
            _log.error((Object)"Unable to parse data ", (Throwable)parseException);
        }
        return null;
    }

    public static int getIndexOfInstance(String recurrence, long recurrenceStartTime, long instanceStartTime) {
        int count = 0;
        DateValue instanceDateValue = RecurrenceUtil._toDateValue(instanceStartTime);
        try {
            DateValue dateValue;
            RecurrenceIterator recurrenceIterator = RecurrenceIteratorFactory.createRecurrenceIterator((String)recurrence, (DateValue)RecurrenceUtil._toDateValue(recurrenceStartTime), (TimeZone)TimeUtils.utcTimezone());
            while (recurrenceIterator.hasNext() && (dateValue = recurrenceIterator.next()).compareTo((Object)instanceDateValue) < 0) {
                ++count;
            }
        }
        catch (ParseException parseException) {
            _log.error((Object)"Unable to parse data ", (Throwable)parseException);
        }
        return count;
    }

    public static CalendarBooking getLastInstanceCalendarBooking(List<CalendarBooking> calendarBookings) {
        calendarBookings = ListUtil.sort(calendarBookings, (Comparator)((Object)new CalendarBookingStartTimeComparator(false)));
        CalendarBooking lastCalendarBooking = (CalendarBooking)calendarBookings.get(0);
        long lastStartTime = 0L;
        for (CalendarBooking calendarBooking : calendarBookings) {
            Recurrence recurrence = calendarBooking.getRecurrenceObj();
            if (recurrence == null) continue;
            if (!RecurrenceUtil.hasLimit(recurrence)) {
                lastCalendarBooking = calendarBooking;
                break;
            }
            CalendarBooking lastCalendarBookingInstance = RecurrenceUtil.getLastCalendarBookingInstance(calendarBooking);
            if (lastCalendarBookingInstance.getStartTime() <= lastStartTime) continue;
            lastStartTime = lastCalendarBookingInstance.getStartTime();
            lastCalendarBooking = calendarBooking;
        }
        return lastCalendarBooking;
    }

    public static Recurrence inTimeZone(Recurrence recurrence, Calendar startTimeJCalendar, TimeZone timeZone) {
        if (recurrence == null) {
            return null;
        }
        recurrence = recurrence.clone();
        TimeZone originalTimeZone = recurrence.getTimeZone();
        ArrayList<Calendar> newExceptionJCalendars = new ArrayList<Calendar>();
        List<Calendar> exceptionJCalendars = recurrence.getExceptionJCalendars();
        Calendar recurrenceStartTimeJCalendar = JCalendarUtil.getJCalendar(startTimeJCalendar, originalTimeZone);
        for (Calendar exceptionJCalendar : exceptionJCalendars) {
            exceptionJCalendar = JCalendarUtil.mergeJCalendar(exceptionJCalendar, recurrenceStartTimeJCalendar, originalTimeZone);
            exceptionJCalendar = JCalendarUtil.getJCalendar(exceptionJCalendar, timeZone);
            newExceptionJCalendars.add(exceptionJCalendar);
        }
        recurrence.setExceptionJCalendars(newExceptionJCalendars);
        ArrayList<PositionalWeekday> newPositionalWeekdays = new ArrayList<PositionalWeekday>();
        List<PositionalWeekday> positionalWeekdays = recurrence.getPositionalWeekdays();
        for (PositionalWeekday positionalWeekday : positionalWeekdays) {
            Calendar jCalendar = JCalendarUtil.getJCalendar(startTimeJCalendar, originalTimeZone);
            Weekday weekday = positionalWeekday.getWeekday();
            jCalendar.set(7, weekday.getCalendarWeekday());
            weekday = Weekday.getWeekday(JCalendarUtil.getJCalendar(jCalendar, timeZone));
            positionalWeekday = new PositionalWeekday(weekday, positionalWeekday.getPosition());
            newPositionalWeekdays.add(positionalWeekday);
        }
        recurrence.setPositionalWeekdays(newPositionalWeekdays);
        recurrence.setTimeZone(timeZone);
        Calendar untilJCalendar = recurrence.getUntilJCalendar();
        if (untilJCalendar != null) {
            untilJCalendar = JCalendarUtil.mergeJCalendar(untilJCalendar, recurrenceStartTimeJCalendar, originalTimeZone);
            untilJCalendar = JCalendarUtil.getJCalendar(untilJCalendar, timeZone);
            recurrence.setUntilJCalendar(untilJCalendar);
        }
        return recurrence;
    }

    protected static CalendarBooking getLastCalendarBookingInstance(CalendarBooking calendarBooking) {
        List<CalendarBooking> calendarBookingInstances = RecurrenceUtil.expandCalendarBooking(calendarBooking, calendarBooking.getStartTime(), Long.MAX_VALUE, 0);
        if (!calendarBookingInstances.isEmpty()) {
            return calendarBookingInstances.get(calendarBookingInstances.size() - 1);
        }
        return calendarBooking;
    }

    protected static boolean hasLimit(Recurrence recurrence) {
        return recurrence.getUntilJCalendar() != null || recurrence.getCount() != 0;
    }

    private static DateValue _toDateValue(long time) {
        Calendar jCalendar = JCalendarUtil.getJCalendar(time);
        return new DateValueImpl(jCalendar.get(1), jCalendar.get(2) + 1, jCalendar.get(5));
    }
}

