/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.calendar.test.util;

import com.liferay.calendar.model.Calendar;
import com.liferay.calendar.service.CalendarLocalServiceUtil;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationParameterMapFactoryUtil;
import com.liferay.exportimport.kernel.service.StagingLocalServiceUtil;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.ListUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;

public class CalendarStagingTestUtil {
    public static void cleanUp() {
        PortletPreferencesLocalServiceUtil.deletePortletPreferencesByPlid((long)0L);
    }

    public static ServiceContext createServiceContext(User user) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setUserId(user.getUserId());
        return serviceContext;
    }

    public static void enableLocalStaging(Group group, boolean enableCalendarStaging) throws PortalException {
        ServiceContext serviceContext = ServiceContextTestUtil.getServiceContext((long)group.getGroupId());
        CalendarStagingTestUtil.addStagingAttribute(serviceContext, StagingUtil.getStagedPortletId((String)"com_liferay_calendar_web_portlet_CalendarAdminPortlet"), (Object)enableCalendarStaging);
        CalendarStagingTestUtil.addStagingAttribute(serviceContext, "PORTLET_CONFIGURATION_ALL", (Object)false);
        CalendarStagingTestUtil.addStagingAttribute(serviceContext, "PORTLET_DATA_ALL", (Object)false);
        CalendarStagingTestUtil.addStagingAttribute(serviceContext, "PORTLET_SETUP_ALL", (Object)false);
        StagingLocalServiceUtil.enableLocalStaging((long)TestPropsValues.getUserId(), (Group)group, (boolean)false, (boolean)false, (ServiceContext)serviceContext);
    }

    public static Calendar getStagingCalendar(Group group, Calendar calendar) throws PortalException {
        if (group.hasStagingGroup()) {
            group = group.getStagingGroup();
        }
        Assert.assertTrue((boolean)group.isStaged());
        return CalendarLocalServiceUtil.fetchCalendarByUuidAndGroupId((String)calendar.getUuid(), (long)group.getGroupId());
    }

    public static void publishLayouts(Group liveGroup, boolean enableCalendarStaging) throws PortalException {
        Group stagingGroup = liveGroup.getStagingGroup();
        List portletIds = null;
        if (enableCalendarStaging) {
            portletIds = ListUtil.fromArray((Object[])new String[]{"com_liferay_calendar_web_portlet_CalendarPortlet"});
        }
        Map parameters = ExportImportConfigurationParameterMapFactoryUtil.buildParameterMap((String)"DATA_STRATEGY_MIRROR_OVERWRITE", (Boolean)true, (Boolean)false, (Boolean)true, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)false, null, (Boolean)true, (Boolean)false, (List)portletIds, (Boolean)false, null, (String)"all", (Boolean)true, (Boolean)true, (String)"CURRENT_USER_ID");
        StagingUtil.publishLayouts((long)TestPropsValues.getUserId(), (long)stagingGroup.getGroupId(), (long)liveGroup.getGroupId(), (boolean)false, (Map)parameters);
    }

    public static void publishPortlet(Group liveGroup, Layout targetLayout, boolean enableCalendarStaging) throws PortalException {
        Group stagingGroup = liveGroup.getStagingGroup();
        Layout sourceLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)targetLayout.getUuid(), (long)stagingGroup.getGroupId(), (boolean)false);
        ArrayList<String> portletIds = new ArrayList<String>();
        portletIds.add("com_liferay_calendar_web_portlet_CalendarAdminPortlet");
        Map parameters = ExportImportConfigurationParameterMapFactoryUtil.buildParameterMap((String)"DATA_STRATEGY_MIRROR_OVERWRITE", (Boolean)true, (Boolean)false, (Boolean)true, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)false, null, (Boolean)true, (Boolean)false, enableCalendarStaging ? portletIds : null, (Boolean)false, null, (String)"all", (Boolean)true, (Boolean)true, (String)"CURRENT_USER_ID");
        StagingUtil.publishPortlet((long)TestPropsValues.getUserId(), (long)stagingGroup.getGroupId(), (long)liveGroup.getGroupId(), (long)sourceLayout.getPlid(), (long)targetLayout.getPlid(), (String)"com_liferay_calendar_web_portlet_CalendarAdminPortlet", (Map)parameters);
    }

    protected static void addStagingAttribute(Map<String, String[]> parameters, String key, Object value) {
        parameters.put(key, new String[]{String.valueOf(value)});
    }

    protected static void addStagingAttribute(ServiceContext serviceContext, String key, Object value) {
        serviceContext.setAttribute("staged--" + key + "--", (Serializable)((Object)String.valueOf(value)));
    }
}

