/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.calendar.test.util;

import com.liferay.calendar.model.Calendar;
import com.liferay.calendar.model.CalendarBooking;
import com.liferay.calendar.model.CalendarResource;
import com.liferay.calendar.notification.NotificationType;
import com.liferay.calendar.recurrence.Recurrence;
import com.liferay.calendar.recurrence.RecurrenceSerializer;
import com.liferay.calendar.service.CalendarBookingLocalServiceUtil;
import com.liferay.calendar.test.util.CalendarTestUtil;
import com.liferay.calendar.test.util.RecurrenceTestUtil;
import com.liferay.calendar.util.CalendarResourceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CalendarBookingTestUtil {
    public static CalendarBooking addAllDayCalendarBooking(User user, Calendar calendar, long startTime, long endTime, ServiceContext serviceContext) throws PortalException {
        return CalendarBookingTestUtil.addCalendarBooking(user, calendar, new long[0], RandomTestUtil.randomLocaleStringMap(), RandomTestUtil.randomLocaleStringMap(), startTime, endTime, true, null, 0, null, 0, null, serviceContext);
    }

    public static CalendarBooking addCalendarBooking(User user, Calendar calendar, long[] childCalendarBookingIds, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long startTime, long endTime, boolean allDay, Recurrence recurrence, int firstReminder, NotificationType firstReminderType, int secondReminder, NotificationType secondReminderType, ServiceContext serviceContext) throws PortalException {
        String firstReminderTypeString = null;
        if (firstReminderType != null) {
            firstReminderTypeString = firstReminderType.getValue();
        }
        String secondReminderTypeString = null;
        if (secondReminderType != null) {
            secondReminderTypeString = secondReminderType.getValue();
        }
        return CalendarBookingLocalServiceUtil.addCalendarBooking((long)user.getUserId(), (long)calendar.getCalendarId(), (long[])childCalendarBookingIds, (long)0L, (long)0L, titleMap, descriptionMap, (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (long)startTime, (long)endTime, (boolean)allDay, (String)RecurrenceSerializer.serialize((Recurrence)recurrence), (long)firstReminder, (String)firstReminderTypeString, (long)secondReminder, (String)secondReminderTypeString, (ServiceContext)serviceContext);
    }

    public static CalendarBooking addCalendarBooking(User user, Calendar calendar, long[] childCalendarBookingIds, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long startTime, long endTime, Recurrence recurrence, int firstReminder, NotificationType firstReminderType, int secondReminder, NotificationType secondReminderType, ServiceContext serviceContext) throws PortalException {
        return CalendarBookingTestUtil.addCalendarBooking(user, calendar, childCalendarBookingIds, titleMap, descriptionMap, startTime, endTime, false, recurrence, firstReminder, firstReminderType, secondReminder, secondReminderType, serviceContext);
    }

    public static CalendarBooking addCalendarBookingWithAction(User user, int action) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setWorkflowAction(action);
        CalendarResource calendarResource = CalendarResourceUtil.getUserCalendarResource((long)user.getUserId(), (ServiceContext)serviceContext);
        Calendar calendar = calendarResource.getDefaultCalendar();
        long startTime = System.currentTimeMillis();
        return CalendarBookingTestUtil.addRegularCalendarBooking(user, calendar, startTime, startTime + 36000000L, serviceContext);
    }

    public static CalendarBooking addChildCalendarBooking(Calendar invitingCalendar, Calendar invitedCalendar) throws PortalException {
        User user = UserLocalServiceUtil.fetchUser((long)invitingCalendar.getUserId());
        long startTime = System.currentTimeMillis();
        long endTime = startTime + 3600000L;
        CalendarBooking masterCalendarBooking = CalendarBookingTestUtil.addMasterCalendarBooking(user, invitingCalendar, new long[]{invitedCalendar.getCalendarId()}, startTime, endTime, CalendarBookingTestUtil.createServiceContext(user));
        return CalendarBookingTestUtil.getChildCalendarBooking(masterCalendarBooking);
    }

    public static CalendarBooking addChildCalendarBooking(Calendar invitingCalendar, Calendar invitedCalendar, long startTime, long endTime) throws PortalException {
        User user = UserLocalServiceUtil.fetchUser((long)invitingCalendar.getUserId());
        CalendarBooking masterCalendarBooking = CalendarBookingTestUtil.addMasterCalendarBooking(user, invitingCalendar, new long[]{invitedCalendar.getCalendarId()}, startTime, endTime, CalendarBookingTestUtil.createServiceContext(user));
        return CalendarBookingTestUtil.getChildCalendarBooking(masterCalendarBooking);
    }

    public static CalendarBooking addDailyRecurringCalendarBooking(User user, ServiceContext serviceContext) throws PortalException {
        Calendar calendar = CalendarTestUtil.addCalendar(user, serviceContext);
        Recurrence recurrence = RecurrenceTestUtil.getDailyRecurrence();
        long startTime = System.currentTimeMillis();
        return CalendarBookingTestUtil.addRecurringCalendarBooking(user, calendar, startTime, startTime + 36000000L, recurrence, serviceContext);
    }

    public static CalendarBooking addDraftCalendarBooking(User user) throws PortalException {
        return CalendarBookingTestUtil.addCalendarBookingWithAction(user, 2);
    }

    public static CalendarBooking addMasterCalendarBooking(Calendar invitingCalendar, Calendar invitedCalendar) throws PortalException {
        User user = UserLocalServiceUtil.fetchUser((long)invitingCalendar.getUserId());
        return CalendarBookingTestUtil.addMasterCalendarBooking(user, invitingCalendar, new long[]{invitedCalendar.getCalendarId()}, CalendarBookingTestUtil.createServiceContext(user));
    }

    public static CalendarBooking addMasterCalendarBooking(User user, Calendar calendar, long[] childCalendarBookingIds, long startTime, long endTime, ServiceContext serviceContext) throws PortalException {
        return CalendarBookingTestUtil.addCalendarBooking(user, calendar, childCalendarBookingIds, RandomTestUtil.randomLocaleStringMap(), RandomTestUtil.randomLocaleStringMap(), startTime, endTime, null, 0, null, 0, null, serviceContext);
    }

    public static CalendarBooking addMasterCalendarBooking(User user, Calendar calendar, long[] childCalendarIds, ServiceContext serviceContext) throws PortalException {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + 36000000L;
        return CalendarBookingTestUtil.addMasterCalendarBooking(user, calendar, childCalendarIds, startTime, endTime, serviceContext);
    }

    public static CalendarBooking addMasterCalendarBookingWithWorkflow(Calendar invitingCalendar, Calendar invitedCalendar, int actionPublish) throws PortalException {
        User user = UserLocalServiceUtil.fetchUser((long)invitingCalendar.getUserId());
        long startTime = System.currentTimeMillis();
        ServiceContext serviceContext = CalendarBookingTestUtil.createServiceContext(user);
        serviceContext.setWorkflowAction(actionPublish);
        return CalendarBookingTestUtil.addMasterCalendarBooking(user, invitingCalendar, new long[]{invitedCalendar.getCalendarId()}, startTime, startTime + 36000000L, serviceContext);
    }

    public static CalendarBooking addMasterRecurringCalendarBooking(Calendar invitedCalendar, Calendar invitingCalendar) throws PortalException {
        User user = UserLocalServiceUtil.getUser((long)invitingCalendar.getUserId());
        long startTime = System.currentTimeMillis();
        long endTime = startTime + 3600000L;
        return CalendarBookingTestUtil.addCalendarBooking(user, invitingCalendar, new long[]{invitedCalendar.getCalendarId()}, RandomTestUtil.randomLocaleStringMap(), RandomTestUtil.randomLocaleStringMap(), startTime, endTime, RecurrenceTestUtil.getDailyRecurrence(), 0, NotificationType.EMAIL, 0, NotificationType.EMAIL, CalendarBookingTestUtil.createServiceContext(user));
    }

    public static CalendarBooking addPublishedCalendarBooking(User user) throws PortalException {
        return CalendarBookingTestUtil.addCalendarBookingWithAction(user, 1);
    }

    public static CalendarBooking addRecurringCalendarBooking(Calendar invitingCalendar, Calendar invitedCalendar, Recurrence recurrence) throws PortalException {
        User user = UserLocalServiceUtil.fetchUser((long)invitingCalendar.getUserId());
        return CalendarBookingTestUtil.addRecurringCalendarBooking(invitingCalendar, invitedCalendar, recurrence, CalendarBookingTestUtil.createServiceContext(user));
    }

    public static CalendarBooking addRecurringCalendarBooking(Calendar invitingCalendar, Calendar invitedCalendar, Recurrence recurrence, ServiceContext serviceContext) throws PortalException {
        User user = UserLocalServiceUtil.fetchUser((long)invitedCalendar.getUserId());
        long startTime = System.currentTimeMillis();
        return CalendarBookingTestUtil.addCalendarBooking(user, invitingCalendar, new long[]{invitedCalendar.getCalendarId()}, RandomTestUtil.randomLocaleStringMap(), RandomTestUtil.randomLocaleStringMap(), startTime, startTime + 36000000L, recurrence, 0, null, 0, null, serviceContext);
    }

    public static CalendarBooking addRecurringCalendarBooking(User user, Calendar calendar, long startTime, long endTime, Recurrence recurrence, ServiceContext serviceContext) throws PortalException {
        return CalendarBookingTestUtil.addCalendarBooking(user, calendar, new long[0], RandomTestUtil.randomLocaleStringMap(), RandomTestUtil.randomLocaleStringMap(), startTime, endTime, recurrence, 0, null, 0, null, serviceContext);
    }

    public static CalendarBooking addRecurringCalendarBooking(User user, Calendar calendar, Recurrence recurrence, ServiceContext serviceContext) throws PortalException {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + 3600000L;
        return CalendarBookingTestUtil.addCalendarBooking(user, calendar, new long[0], RandomTestUtil.randomLocaleStringMap(), RandomTestUtil.randomLocaleStringMap(), startTime, endTime, recurrence, 0, null, 0, null, serviceContext);
    }

    public static CalendarBooking addRecurringCalendarBooking(User user, Recurrence recurrence, ServiceContext serviceContext) throws PortalException {
        Calendar calendar = CalendarTestUtil.addCalendar(user, serviceContext);
        long startTime = System.currentTimeMillis();
        return CalendarBookingTestUtil.addRecurringCalendarBooking(user, calendar, startTime, startTime + 36000000L, recurrence, serviceContext);
    }

    public static CalendarBooking addRegularCalendarBooking(Calendar calendar) throws PortalException {
        User user = UserLocalServiceUtil.fetchUser((long)calendar.getUserId());
        return CalendarBookingTestUtil.addRegularCalendarBooking(user, calendar, CalendarBookingTestUtil.createServiceContext(user));
    }

    public static CalendarBooking addRegularCalendarBooking(User user, Calendar calendar, long startTime, long endTime, ServiceContext serviceContext) throws PortalException {
        return CalendarBookingTestUtil.addCalendarBooking(user, calendar, new long[0], RandomTestUtil.randomLocaleStringMap(), RandomTestUtil.randomLocaleStringMap(), startTime, endTime, null, 0, null, 0, null, serviceContext);
    }

    public static CalendarBooking addRegularCalendarBooking(User user, Calendar calendar, ServiceContext serviceContext) throws PortalException {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + 3600000L;
        return CalendarBookingTestUtil.addCalendarBooking(user, calendar, new long[0], RandomTestUtil.randomLocaleStringMap(), RandomTestUtil.randomLocaleStringMap(), startTime, endTime, null, 0, null, 0, null, serviceContext);
    }

    public static CalendarBooking addRegularCalendarBookingWithReminders(Calendar calendar, long startTime, long endTime, int firstReminder, int secondReminder) throws PortalException {
        User user = UserLocalServiceUtil.getUser((long)calendar.getUserId());
        return CalendarBookingTestUtil.addCalendarBooking(user, calendar, new long[0], RandomTestUtil.randomLocaleStringMap(), RandomTestUtil.randomLocaleStringMap(), startTime, endTime, null, firstReminder, NotificationType.EMAIL, secondReminder, NotificationType.EMAIL, CalendarBookingTestUtil.createServiceContext(user));
    }

    public static CalendarBooking addRegularCalendarBookingWithTitleAndDescription(User user, Calendar calendar, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long startTime, long endTime, ServiceContext serviceContext) throws PortalException {
        return CalendarBookingTestUtil.addCalendarBooking(user, calendar, new long[0], titleMap, descriptionMap, startTime, endTime, null, 0, null, 0, null, serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalendarBooking addRegularCalendarBookingWithWorkflow(User user, Calendar calendar, ServiceContext serviceContext) throws PortalException {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)true);
            serviceContext = (ServiceContext)serviceContext.clone();
            serviceContext.setWorkflowAction(2);
            CalendarBooking calendarBooking = CalendarBookingTestUtil.addRegularCalendarBooking(user, calendar, serviceContext);
            return calendarBooking;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    public static ServiceContext createServiceContext(User user) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setUserId(user.getUserId());
        return serviceContext;
    }

    public static CalendarBooking getChildCalendarBooking(CalendarBooking calendarBooking) {
        List childCalendarBookings = calendarBooking.getChildCalendarBookings();
        Object childCalendarBooking = (CalendarBooking)childCalendarBookings.get(0);
        if (childCalendarBooking.isMasterBooking()) {
            childCalendarBooking = childCalendarBookings.size() > 1 ? (CalendarBooking)childCalendarBookings.get(1) : null;
        }
        return childCalendarBooking;
    }

    public static CalendarBooking updateCalendarBooking(CalendarBooking calendarBooking, long[] childCalendarIds, ServiceContext serviceContext) throws PortalException {
        long startTime = System.currentTimeMillis();
        return CalendarBookingLocalServiceUtil.updateCalendarBooking((long)calendarBooking.getUserId(), (long)calendarBooking.getCalendarBookingId(), (long)calendarBooking.getCalendarId(), (long[])childCalendarIds, (Map)RandomTestUtil.randomLocaleStringMap(), (Map)RandomTestUtil.randomLocaleStringMap(), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (long)startTime, (long)(startTime + 36000000L), (boolean)false, null, (long)0L, null, (long)0L, null, (ServiceContext)serviceContext);
    }

    public static CalendarBooking updateCalendarBooking(CalendarBooking calendarBooking, Map<Locale, String> titleMap, ServiceContext serviceContext) throws PortalException {
        long startTime = System.currentTimeMillis();
        return CalendarBookingLocalServiceUtil.updateCalendarBooking((long)calendarBooking.getUserId(), (long)calendarBooking.getCalendarBookingId(), (long)calendarBooking.getCalendarId(), titleMap, (Map)RandomTestUtil.randomLocaleStringMap(), (String)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), (long)startTime, (long)(startTime + 36000000L), (boolean)false, null, (long)0L, null, (long)0L, null, (ServiceContext)serviceContext);
    }

    public static CalendarBooking updateCalendarBookingInstance(CalendarBooking calendarBooking, int instanceIndex, Map<Locale, String> titleMap, ServiceContext serviceContext) throws PortalException {
        long endTime = calendarBooking.getEndTime() + 86400000L * (long)instanceIndex;
        long startTime = calendarBooking.getStartTime() + 86400000L * (long)instanceIndex;
        return CalendarBookingLocalServiceUtil.updateCalendarBookingInstance((long)calendarBooking.getUserId(), (long)calendarBooking.getCalendarBookingId(), (int)instanceIndex, (long)calendarBooking.getCalendarId(), titleMap, (Map)calendarBooking.getDescriptionMap(), (String)calendarBooking.getLocation(), (long)startTime, (long)endTime, (boolean)false, null, (boolean)false, (long)0L, null, (long)0L, null, (ServiceContext)serviceContext);
    }

    public static CalendarBooking updateCalendarBookingInstance(User user, CalendarBooking calendarBooking, int instanceIndex, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long instanceStartTime, long instanceEndTime, ServiceContext serviceContext) throws PortalException {
        return CalendarBookingLocalServiceUtil.updateCalendarBookingInstance((long)user.getUserId(), (long)calendarBooking.getCalendarBookingId(), (int)instanceIndex, (long)calendarBooking.getCalendarId(), titleMap, descriptionMap, (String)calendarBooking.getLocation(), (long)instanceStartTime, (long)instanceEndTime, (boolean)false, null, (boolean)false, (long)0L, null, (long)0L, null, (ServiceContext)serviceContext);
    }

    public static CalendarBooking updateCalendarBookingInstanceAndAllFollowing(CalendarBooking calendarBooking, int instanceIndex, Map<Locale, String> titleMap, ServiceContext serviceContext) throws PortalException {
        long endTime = calendarBooking.getEndTime() + 86400000L * (long)instanceIndex;
        long startTime = calendarBooking.getStartTime() + 86400000L * (long)instanceIndex;
        return CalendarBookingLocalServiceUtil.updateCalendarBookingInstance((long)calendarBooking.getUserId(), (long)calendarBooking.getCalendarBookingId(), (int)instanceIndex, (long)calendarBooking.getCalendarId(), titleMap, (Map)calendarBooking.getDescriptionMap(), (String)calendarBooking.getLocation(), (long)startTime, (long)endTime, (boolean)calendarBooking.isAllDay(), (String)calendarBooking.getRecurrence(), (boolean)true, (long)calendarBooking.getFirstReminder(), (String)calendarBooking.getFirstReminderType(), (long)calendarBooking.getSecondReminder(), (String)calendarBooking.getSecondReminderType(), (ServiceContext)serviceContext);
    }

    public static CalendarBooking updateCalendarBookingInstanceAndAllFollowing(User user, CalendarBooking calendarBooking, int instanceIndex, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long instanceStartTime, long instanceEndTime, ServiceContext serviceContext) throws PortalException {
        return CalendarBookingLocalServiceUtil.updateCalendarBookingInstance((long)user.getUserId(), (long)calendarBooking.getCalendarBookingId(), (int)instanceIndex, (long)calendarBooking.getCalendarId(), titleMap, descriptionMap, (String)calendarBooking.getLocation(), (long)instanceStartTime, (long)instanceEndTime, (boolean)calendarBooking.isAllDay(), (String)calendarBooking.getRecurrence(), (boolean)true, (long)calendarBooking.getFirstReminder(), (String)calendarBooking.getFirstReminderType(), (long)calendarBooking.getSecondReminder(), (String)calendarBooking.getSecondReminderType(), (ServiceContext)serviceContext);
    }

    public static CalendarBooking updateRecurringCalendarBookingInstanceAndAllFollowing(User user, CalendarBooking calendarBooking, int instanceIndex, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long instanceStartTime, long instanceEndTime, String recurrence, ServiceContext serviceContext) throws PortalException {
        return CalendarBookingLocalServiceUtil.updateCalendarBookingInstance((long)user.getUserId(), (long)calendarBooking.getCalendarBookingId(), (int)instanceIndex, (long)calendarBooking.getCalendarId(), titleMap, descriptionMap, (String)calendarBooking.getLocation(), (long)instanceStartTime, (long)instanceEndTime, (boolean)false, (String)recurrence, (boolean)true, (long)0L, null, (long)0L, null, (ServiceContext)serviceContext);
    }
}

