/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import java.awt.image.RGBImageFilter;
import java.io.Serializable;

public abstract class TransferFilter
extends RGBImageFilter
implements Serializable {
    protected int[] rTable;
    protected int[] gTable;
    protected int[] bTable;
    protected boolean initialized = false;

    public TransferFilter() {
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int n, int n2, int n3) {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        int n4 = n3 & 0xFF000000;
        int n5 = n3 >> 16 & 0xFF;
        int n6 = n3 >> 8 & 0xFF;
        int n7 = n3 & 0xFF;
        n5 = this.rTable[n5];
        n6 = this.gTable[n6];
        n7 = this.bTable[n7];
        return n4 | n5 << 16 | n6 << 8 | n7;
    }

    public void setDimensions(int n, int n2) {
        this.initialized = false;
        super.setDimensions(n, n2);
    }

    protected void initialize() {
        this.bTable = this.makeTable();
        this.gTable = this.bTable;
        this.rTable = this.bTable;
    }

    protected int[] makeTable() {
        int[] nArray = new int[256];
        int n = 0;
        while (n < 256) {
            nArray[n] = this.transferFunction(n);
            ++n;
        }
        return nArray;
    }

    protected int transferFunction(int n) {
        return 0;
    }
}

