/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.captcha.recaptcha;

import com.liferay.captcha.simplecaptcha.SimpleCaptchaImpl;
import com.liferay.portal.kernel.captcha.Captcha;
import com.liferay.portal.kernel.captcha.CaptchaConfigurationException;
import com.liferay.portal.kernel.captcha.CaptchaException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"captcha.engine.impl=com.liferay.captcha.recaptcha.ReCaptchaImpl"}, service={Captcha.class})
public class ReCaptchaImpl
extends SimpleCaptchaImpl {
    private static final String _TAGLIB_PATH = "/captcha/recaptcha.jsp";
    private static final Log _log = LogFactoryUtil.getLog(ReCaptchaImpl.class);

    @Override
    public String getTaglibPath() {
        return _TAGLIB_PATH;
    }

    @Override
    public void serveImage(HttpServletRequest request, HttpServletResponse response) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void serveImage(ResourceRequest resourceRequest, ResourceResponse resourceResponse) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean validateChallenge(HttpServletRequest request) throws CaptchaException {
        String reCaptchaResponse = ParamUtil.getString((HttpServletRequest)request, (String)"g-recaptcha-response");
        while (Validator.isBlank((String)reCaptchaResponse) && request instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)request;
            request = (HttpServletRequest)httpServletRequestWrapper.getRequest();
            reCaptchaResponse = ParamUtil.getString((HttpServletRequest)request, (String)"g-recaptcha-response");
        }
        if (Validator.isBlank((String)reCaptchaResponse)) {
            _log.error((Object)("CAPTCHA text is null. User " + request.getRemoteUser() + " may be trying to circumvent the CAPTCHA."));
            throw new CaptchaTextException();
        }
        Http.Options options = new Http.Options();
        try {
            options.addPart("secret", PrefsPropsUtil.getString((String)"captcha.engine.recaptcha.key.private", (String)PropsValues.CAPTCHA_ENGINE_RECAPTCHA_KEY_PRIVATE));
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
        }
        options.addPart("remoteip", request.getRemoteAddr());
        options.addPart("response", reCaptchaResponse);
        options.setLocation(PropsValues.CAPTCHA_ENGINE_RECAPTCHA_URL_VERIFY);
        options.setPost(true);
        String content = null;
        try {
            content = HttpUtil.URLtoString((Http.Options)options);
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
            throw new CaptchaConfigurationException();
        }
        if (content == null) {
            _log.error((Object)"reCAPTCHA did not return a result");
            throw new CaptchaConfigurationException();
        }
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)content);
            String success = jsonObject.getString("success");
            if (StringUtil.equalsIgnoreCase((String)success, (String)"true")) {
                return true;
            }
            JSONArray jsonArray = jsonObject.getJSONArray("error-codes");
            if (jsonArray == null || jsonArray.length() == 0) {
                _log.error((Object)"reCAPTCHA encountered an error");
                throw new CaptchaConfigurationException();
            }
            StringBundler sb = new StringBundler(jsonArray.length() * 2 - 1);
            for (int i = 0; i < jsonArray.length(); ++i) {
                sb.append(jsonArray.getString(i));
                if (i >= jsonArray.length() - 1) continue;
                sb.append(", ");
            }
            _log.error((Object)("reCAPTCHA encountered an error: " + sb.toString()));
            throw new CaptchaConfigurationException();
        }
        catch (JSONException jsone) {
            _log.error((Object)("reCAPTCHA did not return a valid result: " + content), (Throwable)jsone);
            throw new CaptchaConfigurationException();
        }
    }

    @Override
    protected boolean validateChallenge(PortletRequest portletRequest) throws CaptchaException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return this.validateChallenge(request);
    }
}

