/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.captcha.simplecaptcha;

import com.liferay.captcha.configuration.CaptchaConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.captcha.CaptchaException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.captcha.Captcha;
import nl.captcha.backgrounds.BackgroundProducer;
import nl.captcha.gimpy.GimpyRenderer;
import nl.captcha.noise.NoiseProducer;
import nl.captcha.servlet.CaptchaServletUtil;
import nl.captcha.text.producer.TextProducer;
import nl.captcha.text.renderer.WordRenderer;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.captcha.configuration.CaptchaConfiguration"}, property={"captcha.engine.impl=com.liferay.captcha.simplecaptcha.SimpleCaptchaImpl"}, service={com.liferay.portal.kernel.captcha.Captcha.class})
public class SimpleCaptchaImpl
implements com.liferay.portal.kernel.captcha.Captcha {
    @Reference
    protected Portal portal;
    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.captcha.impl)(release.schema.version>=1.1.0))")
    protected Release release;
    private static final String _TAGLIB_PATH = "/captcha/simplecaptcha.jsp";
    private static final Log _log = LogFactoryUtil.getLog(SimpleCaptchaImpl.class);
    private BackgroundProducer[] _backgroundProducers;
    private volatile CaptchaConfiguration _captchaConfiguration;
    private GimpyRenderer[] _gimpyRenderers;
    private final Map<String, Object> _instances = new ConcurrentHashMap<String, Object>();
    private NoiseProducer[] _noiseProducers;
    private TextProducer[] _textProducers;
    private WordRenderer[] _wordRenderers;

    public void check(HttpServletRequest httpServletRequest) throws CaptchaException {
        if (!this.isEnabled(httpServletRequest)) {
            return;
        }
        if (!this.validateChallenge(httpServletRequest)) {
            throw new CaptchaTextException();
        }
        this.incrementCounter(httpServletRequest);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"CAPTCHA text is valid");
        }
    }

    public void check(PortletRequest portletRequest) throws CaptchaException {
        this.check(this.portal.getHttpServletRequest(portletRequest));
    }

    public String getTaglibPath() {
        return _TAGLIB_PATH;
    }

    public boolean isEnabled(HttpServletRequest httpServletRequest) {
        if (this.isExceededMaxChallenges(httpServletRequest)) {
            return false;
        }
        return this._captchaConfiguration.maxChallenges() >= 0;
    }

    public boolean isEnabled(PortletRequest portletRequest) {
        return this.isEnabled(this.portal.getHttpServletRequest(portletRequest));
    }

    public void serveImage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        HttpSession httpSession = this._getHttpSession(httpServletRequest);
        String key = "CAPTCHA_TEXT";
        String portletId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"portletId");
        if (Validator.isNotNull((String)portletId)) {
            key = this.portal.getPortletNamespace(portletId) + key;
        }
        Captcha simpleCaptcha = this.getSimpleCaptcha();
        httpSession.setAttribute(key, (Object)simpleCaptcha.getAnswer());
        httpServletResponse.setContentType("image/png");
        CaptchaServletUtil.writeImage((OutputStream)httpServletResponse.getOutputStream(), simpleCaptcha.getImage());
    }

    public String serveImage(OutputStream outputStream) throws IOException {
        Captcha simpleCaptcha = this.getSimpleCaptcha();
        CaptchaServletUtil.writeImage(outputStream, simpleCaptcha.getImage());
        return simpleCaptcha.getAnswer();
    }

    public void serveImage(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException {
        PortletSession portletSession = resourceRequest.getPortletSession();
        Captcha simpleCaptcha = this.getSimpleCaptcha();
        String key = "CAPTCHA_TEXT";
        String portletId = this.portal.getPortletId((PortletRequest)resourceRequest);
        if (Validator.isNotNull((String)portletId)) {
            key = this.portal.getPortletNamespace(portletId) + key;
        }
        portletSession.setAttribute(key, (Object)simpleCaptcha.getAnswer());
        resourceResponse.setContentType("image/png");
        CaptchaServletUtil.writeImage(resourceResponse.getPortletOutputStream(), simpleCaptcha.getImage());
    }

    protected void activate() {
        this.initBackgroundProducers();
        this.initGimpyRenderers();
        this.initNoiseProducers();
        this.initTextProducers();
        this.initWordRenderers();
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._captchaConfiguration = (CaptchaConfiguration)ConfigurableUtil.createConfigurable(CaptchaConfiguration.class, properties);
        this.activate();
    }

    protected BackgroundProducer getBackgroundProducer() {
        if (this._backgroundProducers.length == 1) {
            return this._backgroundProducers[0];
        }
        int pos = RandomUtil.nextInt((int)this._backgroundProducers.length);
        return this._backgroundProducers[pos];
    }

    protected GimpyRenderer getGimpyRenderer() {
        if (this._gimpyRenderers.length == 1) {
            return this._gimpyRenderers[0];
        }
        int pos = RandomUtil.nextInt((int)this._gimpyRenderers.length);
        return this._gimpyRenderers[pos];
    }

    protected int getHeight() {
        return this._captchaConfiguration.simpleCaptchaHeight();
    }

    protected NoiseProducer getNoiseProducer() {
        if (this._noiseProducers.length == 1) {
            return this._noiseProducers[0];
        }
        int pos = RandomUtil.nextInt((int)this._noiseProducers.length);
        return this._noiseProducers[pos];
    }

    protected Captcha getSimpleCaptcha() {
        Captcha.Builder captchaBuilder = new Captcha.Builder(this.getWidth(), this.getHeight());
        captchaBuilder.addText(this.getTextProducer(), this.getWordRenderer());
        captchaBuilder.addBackground(this.getBackgroundProducer());
        captchaBuilder.gimp(this.getGimpyRenderer());
        captchaBuilder.addNoise(this.getNoiseProducer());
        captchaBuilder.addBorder();
        return captchaBuilder.build();
    }

    protected TextProducer getTextProducer() {
        if (this._textProducers.length == 1) {
            return this._textProducers[0];
        }
        int pos = RandomUtil.nextInt((int)this._textProducers.length);
        return this._textProducers[pos];
    }

    protected int getWidth() {
        return this._captchaConfiguration.simpleCaptchaWidth();
    }

    protected WordRenderer getWordRenderer() {
        if (this._wordRenderers.length == 1) {
            return this._wordRenderers[0];
        }
        int pos = RandomUtil.nextInt((int)this._wordRenderers.length);
        return this._wordRenderers[pos];
    }

    protected void incrementCounter(HttpServletRequest httpServletRequest) {
        if (this._captchaConfiguration.maxChallenges() > 0 && Validator.isNotNull((String)httpServletRequest.getRemoteUser())) {
            HttpSession httpSession = this._getHttpSession(httpServletRequest);
            Integer count = (Integer)httpSession.getAttribute(this._getHttpSessionKey("CAPTCHA_COUNT", httpServletRequest));
            httpSession.setAttribute(this._getHttpSessionKey("CAPTCHA_COUNT", httpServletRequest), (Object)this.incrementCounter(count));
        }
    }

    protected Integer incrementCounter(Integer count) {
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        return count;
    }

    protected void incrementCounter(PortletRequest portletRequest) {
        this.incrementCounter(this.portal.getHttpServletRequest(portletRequest));
    }

    protected void initBackgroundProducers() {
        String[] backgroundProducerClassNames = this._captchaConfiguration.simpleCaptchaBackgroundProducers();
        this._backgroundProducers = new BackgroundProducer[backgroundProducerClassNames.length];
        for (int i = 0; i < backgroundProducerClassNames.length; ++i) {
            String backgroundProducerClassName = backgroundProducerClassNames[i];
            this._backgroundProducers[i] = (BackgroundProducer)this._getInstance(backgroundProducerClassName);
        }
    }

    protected void initGimpyRenderers() {
        String[] gimpyRendererClassNames = this._captchaConfiguration.simpleCaptchaGimpyRenderers();
        this._gimpyRenderers = new GimpyRenderer[gimpyRendererClassNames.length];
        for (int i = 0; i < gimpyRendererClassNames.length; ++i) {
            String gimpyRendererClassName = gimpyRendererClassNames[i];
            this._gimpyRenderers[i] = (GimpyRenderer)this._getInstance(gimpyRendererClassName);
        }
    }

    protected void initNoiseProducers() {
        String[] noiseProducerClassNames = this._captchaConfiguration.simpleCaptchaNoiseProducers();
        this._noiseProducers = new NoiseProducer[noiseProducerClassNames.length];
        for (int i = 0; i < noiseProducerClassNames.length; ++i) {
            String noiseProducerClassName = noiseProducerClassNames[i];
            this._noiseProducers[i] = (NoiseProducer)this._getInstance(noiseProducerClassName);
        }
    }

    protected void initTextProducers() {
        String[] textProducerClassNames = this._captchaConfiguration.simpleCaptchaTextProducers();
        this._textProducers = new TextProducer[textProducerClassNames.length];
        for (int i = 0; i < textProducerClassNames.length; ++i) {
            String textProducerClassName = textProducerClassNames[i];
            this._textProducers[i] = (TextProducer)this._getInstance(textProducerClassName);
        }
    }

    protected void initWordRenderers() {
        String[] wordRendererClassNames = this._captchaConfiguration.simpleCaptchaWordRenderers();
        this._wordRenderers = new WordRenderer[wordRendererClassNames.length];
        for (int i = 0; i < wordRendererClassNames.length; ++i) {
            String wordRendererClassName = wordRendererClassNames[i];
            this._wordRenderers[i] = (WordRenderer)this._getInstance(wordRendererClassName);
        }
    }

    protected boolean isExceededMaxChallenges(HttpServletRequest httpServletRequest) {
        if (this._captchaConfiguration.maxChallenges() > 0) {
            HttpSession httpSession = this._getHttpSession(httpServletRequest);
            Integer count = (Integer)httpSession.getAttribute(this._getHttpSessionKey("CAPTCHA_COUNT", httpServletRequest));
            return this.isExceededMaxChallenges(count);
        }
        return false;
    }

    protected boolean isExceededMaxChallenges(Integer count) {
        return count != null && count >= this._captchaConfiguration.maxChallenges();
    }

    protected boolean isExceededMaxChallenges(PortletRequest portletRequest) {
        return this.isExceededMaxChallenges(this.portal.getHttpServletRequest(portletRequest));
    }

    protected void setCaptchaConfiguration(CaptchaConfiguration captchaConfiguration) {
        this._captchaConfiguration = captchaConfiguration;
    }

    protected boolean validateChallenge(HttpServletRequest httpServletRequest) throws CaptchaException {
        String httpSessionKey;
        HttpSession httpSession = this._getHttpSession(httpServletRequest);
        String captchaText = (String)httpSession.getAttribute(httpSessionKey = this._getHttpSessionKey("CAPTCHA_TEXT", httpServletRequest));
        if (captchaText == null) {
            _log.error((Object)("CAPTCHA text is null. User " + httpServletRequest.getRemoteUser() + " may be trying to circumvent the CAPTCHA."));
            throw new CaptchaTextException();
        }
        boolean valid = captchaText.equals(ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"captchaText"));
        if (valid) {
            httpSession.removeAttribute(httpSessionKey);
        }
        return valid;
    }

    protected boolean validateChallenge(PortletRequest portletRequest) throws CaptchaException {
        return this.validateChallenge(this.portal.getHttpServletRequest(portletRequest));
    }

    private HttpSession _getHttpSession(HttpServletRequest httpServletRequest) {
        HttpServletRequest originalHttpServletRequest = this.portal.getOriginalServletRequest(httpServletRequest);
        return originalHttpServletRequest.getSession();
    }

    private String _getHttpSessionKey(String key, HttpServletRequest httpServletRequest) {
        String portletId = this.portal.getPortletId(httpServletRequest);
        if (Validator.isNotNull((String)portletId)) {
            return this.portal.getPortletNamespace(portletId) + key;
        }
        return key;
    }

    private Object _getInstance(String className) {
        Object instance = this._instances.get(className = className.trim());
        if (instance != null) {
            return instance;
        }
        try {
            Class<?> clazz = this._loadClass(className);
            instance = clazz.newInstance();
            this._instances.put(className, instance);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to load " + className), (Throwable)exception);
        }
        return instance;
    }

    private Class<?> _loadClass(String className) throws Exception {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        return classLoader.loadClass(className);
    }
}

