/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.service.persistence.impl.TableMapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import javax.sql.DataSource;

public class CTTableMapperHelper {
    private final CTService<?> _ctService;
    private final String _leftColumnName;
    private String _rightColumnName;
    private final String _tableName;

    public CTTableMapperHelper(CTService<?> ctService, String tableName, String leftColumnName) {
        this._ctService = ctService;
        this._tableName = tableName;
        this._leftColumnName = leftColumnName;
    }

    public void delete(long ctCollectionId) throws Exception {
        this._ctService.updateWithUnsafeFunction(ctPersistence -> {
            Connection connection = CurrentConnectionUtil.getConnection((DataSource)ctPersistence.getDataSource());
            try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"delete from ", this._tableName, " where ctCollectionId = ", ctCollectionId}));){
                preparedStatement.executeUpdate();
            }
            return null;
        });
    }

    public void publish(long ctCollectionId, PortalCacheManager<?, ?> portalCacheManager) throws Exception {
        if (this._rightColumnName == null) {
            throw new NullPointerException(StringBundler.concat((String[])new String[]{"Missing column name for ", this._tableName, " with column name ", this._leftColumnName}));
        }
        int count = (Integer)this._ctService.updateWithUnsafeFunction(ctPersistence -> this._publish((CTPersistence<?>)ctPersistence, ctCollectionId));
        if (count != 0) {
            this._clearCache(portalCacheManager, this._tableName, this._leftColumnName, this._rightColumnName);
            this._clearCache(portalCacheManager, this._tableName, this._rightColumnName, this._leftColumnName);
        }
    }

    public void undo(long fromCTCollectionId, long toCTCollectionId) throws Exception {
        if (this._rightColumnName == null) {
            throw new NullPointerException(StringBundler.concat((String[])new String[]{"Missing column name for ", this._tableName, " with column name ", this._leftColumnName}));
        }
        this._ctService.updateWithUnsafeFunction(ctPersistence -> {
            Connection connection = CurrentConnectionUtil.getConnection((DataSource)ctPersistence.getDataSource());
            try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"insert into ", this._tableName, " (companyId, ", this._leftColumnName, ", ", this._rightColumnName, ", ctCollectionId, ctChangeType) select ", "t1.companyId, t1.", this._leftColumnName, ", t1.", this._rightColumnName, ", ", toCTCollectionId, " as ctCollectionId, ? as ctChangeType from ", this._tableName, " t1 where t1.ctCollectionId = ", fromCTCollectionId, " and t1.ctChangeType = ?"}));){
                preparedStatement.setBoolean(1, true);
                preparedStatement.setBoolean(2, false);
                preparedStatement.executeUpdate();
                preparedStatement.setBoolean(1, false);
                preparedStatement.setBoolean(2, true);
                preparedStatement.executeUpdate();
            }
            return null;
        });
    }

    protected void setRightColumnName(String rightColumnName) {
        this._rightColumnName = rightColumnName;
    }

    private void _clearCache(PortalCacheManager<?, ?> portalCacheManager, String tableName, String leftColumnName, String rightColumnName) {
        String portalCacheName = StringBundler.concat((String[])new String[]{TableMapper.class.getName(), "-", tableName, "-", leftColumnName, "-To-", rightColumnName});
        PortalCache portalCache = portalCacheManager.fetchPortalCache(portalCacheName);
        if (portalCache != null) {
            portalCache.removeAll();
        }
    }

    private int _publish(CTPersistence<?> ctPersistence, long ctCollectionId) throws Exception {
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)ctPersistence.getDataSource());
        ArrayList<AbstractMap.SimpleImmutableEntry<Long, Long>> entries = new ArrayList<AbstractMap.SimpleImmutableEntry<Long, Long>>();
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select ", this._leftColumnName, ", ", this._rightColumnName, " from ", this._tableName, " where ctCollectionId = ", ctCollectionId, " and ctChangeType = ?"}));){
            preparedStatement.setBoolean(1, false);
            Throwable throwable = null;
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    entries.add(new AbstractMap.SimpleImmutableEntry<Long, Long>(resultSet.getLong(1), resultSet.getLong(2)));
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        int count = 0;
        if (!entries.isEmpty()) {
            StringBundler sb = new StringBundler(8 * entries.size() + 3);
            sb.append("delete from ");
            sb.append(this._tableName);
            sb.append(" where ctCollectionId = 0 and ((");
            for (Map.Entry entry : entries) {
                sb.append(this._leftColumnName);
                sb.append(" = ");
                sb.append(entry.getKey());
                sb.append(" and ");
                sb.append(this._rightColumnName);
                sb.append(" = ");
                sb.append(entry.getValue());
                sb.append(") or (");
            }
            sb.setStringAt("))", sb.index() - 1);
            Throwable throwable = null;
            try (PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());){
                count += preparedStatement.executeUpdate();
            }
            catch (Throwable throwable4) {
                Throwable throwable5 = throwable4;
                throw throwable4;
            }
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"insert into ", this._tableName, " (companyId, ", this._leftColumnName, ", ", this._rightColumnName, ", ctCollectionId) select t1.companyId, t1.", this._leftColumnName, ", t1.", this._rightColumnName, ", 0 as ctCollectionId from ", this._tableName, " t1 left join ", this._tableName, " t2 on t2.ctCollectionId = 0 and t2.", this._leftColumnName, " = t1.", this._leftColumnName, " and t2.", this._rightColumnName, " = t1.", this._rightColumnName, " where t1.ctCollectionId = ", ctCollectionId, " and t1.ctChangeType = ?"}));){
            preparedStatement.setBoolean(1, true);
        }
        return count += preparedStatement.executeUpdate();
    }
}

