/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.messaging;

import com.liferay.change.tracking.service.CTMessageLocalService;
import com.liferay.change.tracking.spi.listener.CTEventListener;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTEventListener.class})
public class CTMessageEventListener
implements CTEventListener {
    @Reference
    private CTMessageLocalService _ctMessageLocalService;
    @Reference
    private MessageBus _messageBus;

    public void onAfterPublish(long ctCollectionId) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            List messages = this._ctMessageLocalService.getMessages(ctCollectionId);
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)0L);){
                for (Message message : messages) {
                    this._messageBus.sendMessage(message.getDestinationName(), message);
                }
            }
            return null;
        });
    }
}

