/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.closure.CTClosure;
import com.liferay.change.tracking.closure.CTClosureFactory;
import com.liferay.change.tracking.exception.CTEnclosureException;
import com.liferay.change.tracking.internal.CTEnclosureUtil;
import com.liferay.change.tracking.internal.CTServiceRegistry;
import com.liferay.change.tracking.model.CTAutoResolutionInfo;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTCollectionTable;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTProcessLocalService;
import com.liferay.change.tracking.service.base.CTCollectionServiceBaseImpl;
import com.liferay.change.tracking.service.persistence.CTAutoResolutionInfoPersistence;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.GroupTable;
import com.liferay.portal.kernel.model.UserGroupRoleTable;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.security.permission.InlineSQLHelper;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.search.model.uid.UIDFactory;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=ct", "json.web.service.context.path=CTCollection"}, service={AopService.class})
public class CTCollectionServiceImpl
extends CTCollectionServiceBaseImpl {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CTAutoResolutionInfoPersistence _ctAutoResolutionInfoPersistence;
    @Reference
    private CTClosureFactory _ctClosureFactory;
    @Reference(target="(model.class.name=com.liferay.change.tracking.model.CTCollection)")
    private ModelResourcePermission<CTCollection> _ctCollectionModelResourcePermission;
    @Reference
    private CTProcessLocalService _ctProcessLocalService;
    @Reference
    private CTServiceRegistry _ctServiceRegistry;
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference
    private InlineSQLHelper _inlineSQLHelper;
    @Reference(target="(resource.name=com.liferay.change.tracking)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private UIDFactory _uidFactory;

    public CTCollection addCTCollection(long companyId, long userId, String name, String description) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_PUBLICATION");
        return this.ctCollectionLocalService.addCTCollection(companyId, userId, name, description);
    }

    public void deleteCTAutoResolutionInfo(long ctAutoResolutionInfoId) throws PortalException {
        CTAutoResolutionInfo ctAutoResolutionInfo = this._ctAutoResolutionInfoPersistence.fetchByPrimaryKey(ctAutoResolutionInfoId);
        if (ctAutoResolutionInfo == null) {
            return;
        }
        this._ctCollectionModelResourcePermission.check(this.getPermissionChecker(), ctAutoResolutionInfo.getCtCollectionId(), "UPDATE");
        this.ctCollectionLocalService.deleteCTAutoResolutionInfo(ctAutoResolutionInfoId);
    }

    public CTCollection deleteCTCollection(CTCollection ctCollection) throws PortalException {
        this._ctCollectionModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ctCollection, "DELETE");
        return this.ctCollectionLocalService.deleteCTCollection(ctCollection);
    }

    public void discardCTEntries(long ctCollectionId, long modelClassNameId, long modelClassPK) throws PortalException {
        CTCollection ctCollection = this.ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
        this._ctCollectionModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ctCollection, "UPDATE");
        if (ctCollection.getStatus() != 2 && ctCollection.getStatus() != 1) {
            throw new PortalException("Change tracking collection " + ctCollection + " is read only");
        }
        List discardCTEntries = this.ctCollectionLocalService.getDiscardCTEntries(ctCollectionId, modelClassNameId, modelClassPK);
        HashMap<Long, List> ctEntryMap = new HashMap<Long, List>();
        for (CTEntry cTEntry : discardCTEntries) {
            List ctEntries = ctEntryMap.computeIfAbsent(cTEntry.getModelClassNameId(), key -> new ArrayList());
            ctEntries.add(cTEntry);
        }
        for (Map.Entry entry : ctEntryMap.entrySet()) {
            this._discardCTEntries(ctCollection, (Long)entry.getKey(), (List)entry.getValue());
        }
    }

    public void discardCTEntry(long ctCollectionId, long modelClassNameId, long modelClassPK) throws PortalException {
        long classNameId;
        CTCollection ctCollection = this.ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
        this._ctCollectionModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ctCollection, "UPDATE");
        if (ctCollection.getStatus() != 2 && ctCollection.getStatus() != 1) {
            throw new PortalException("Change tracking collection " + ctCollection + " is read only");
        }
        CTClosure ctClosure = this._ctClosureFactory.create(ctCollection.getCtCollectionId());
        Map<Long, Set<Long>> enclosureMap = CTEnclosureUtil.getEnclosureMap(ctClosure, modelClassNameId, modelClassPK);
        for (Map.Entry<Long, Long> entry : CTEnclosureUtil.getEnclosureParentEntries(ctClosure, enclosureMap)) {
            long classPK;
            classNameId = entry.getKey();
            int count = this.ctEntryPersistence.countByC_MCNI_MCPK(ctCollectionId, classNameId, classPK = entry.getValue().longValue());
            if (count <= 0) continue;
            throw new CTEnclosureException(StringBundler.concat((Object[])new Object[]{"{classNameId=", classNameId, ", classPK=", classPK, ", ctCollectionId=", ctCollectionId, "}"}));
        }
        for (Map.Entry<Long, Object> entry : enclosureMap.entrySet()) {
            classNameId = entry.getKey();
            Set classPKs = (Set)entry.getValue();
            ArrayList<CTEntry> ctEntries = new ArrayList<CTEntry>(classPKs.size());
            Iterator iterator = classPKs.iterator();
            while (iterator.hasNext()) {
                long classPK = (Long)iterator.next();
                CTEntry ctEntry = this.ctEntryPersistence.fetchByC_MCNI_MCPK(ctCollectionId, classNameId, classPK);
                if (ctEntry == null) continue;
                ctEntries.add(ctEntry);
            }
            if (ctEntries.isEmpty()) continue;
            this._discardCTEntries(ctCollection, classNameId, ctEntries);
        }
    }

    public List<CTCollection> getCTCollections(long companyId, int[] statuses, int start, int end, OrderByComparator<CTCollection> orderByComparator) {
        if (statuses == null) {
            return this.ctCollectionPersistence.filterFindByCompanyId(companyId, start, end, orderByComparator);
        }
        return this.ctCollectionPersistence.filterFindByC_S(companyId, statuses, start, end, orderByComparator);
    }

    public List<CTCollection> getCTCollections(long companyId, int[] statuses, String keywords, int start, int end, OrderByComparator<CTCollection> orderByComparator) {
        DSLQuery dslQuery = DSLQueryFactoryUtil.select((Table)CTCollectionTable.INSTANCE).from((Table)CTCollectionTable.INSTANCE).where(this._getPredicate(companyId, statuses, keywords)).orderBy((Table)CTCollectionTable.INSTANCE, orderByComparator).limit(start, end);
        return (List)this.ctCollectionPersistence.dslQuery(dslQuery);
    }

    public int getCTCollectionsCount(long companyId, int[] statuses, String keywords) {
        GroupByStep dslQuery = DSLQueryFactoryUtil.count().from((Table)CTCollectionTable.INSTANCE).where(this._getPredicate(companyId, statuses, keywords));
        return this.ctCollectionPersistence.dslQueryCount((DSLQuery)dslQuery);
    }

    public void publishCTCollection(long userId, long ctCollectionId) throws PortalException {
        this._ctCollectionModelResourcePermission.check(this.getPermissionChecker(), ctCollectionId, "PUBLISH");
        this._ctProcessLocalService.addCTProcess(userId, ctCollectionId);
    }

    public CTCollection undoCTCollection(long ctCollectionId, long userId, String name, String description) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        this._ctCollectionModelResourcePermission.check(permissionChecker, ctCollectionId, "VIEW");
        this._portletResourcePermission.check(permissionChecker, null, "ADD_PUBLICATION");
        return this.ctCollectionLocalService.undoCTCollection(ctCollectionId, userId, name, description);
    }

    public CTCollection updateCTCollection(long userId, long ctCollectionId, String name, String description) throws PortalException {
        this._ctCollectionModelResourcePermission.check(this.getPermissionChecker(), ctCollectionId, "UPDATE");
        return this.ctCollectionLocalService.updateCTCollection(userId, ctCollectionId, name, description);
    }

    private void _discardCTEntries(CTCollection ctCollection, long classNameId, List<CTEntry> ctEntries) {
        CTService<?> ctService = this._ctServiceRegistry.getCTService(classNameId);
        ctService.updateWithUnsafeFunction(ctPersistence -> {
            Set primaryKeyNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.PK);
            if (primaryKeyNames.size() != 1) {
                throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"{primaryKeyNames=", primaryKeyNames, ", tableName=", ctPersistence.getTableName(), "}"}));
            }
            Iterator iterator = primaryKeyNames.iterator();
            String primaryKeyName = (String)iterator.next();
            StringBundler sb = new StringBundler(2 * ctEntries.size() + 7);
            sb.append("delete from ");
            sb.append(ctPersistence.getTableName());
            sb.append(" where ctCollectionId = ");
            sb.append(ctCollection.getCtCollectionId());
            sb.append(" and ");
            sb.append(primaryKeyName);
            sb.append(" in (");
            for (CTEntry ctEntry : ctEntries) {
                sb.append(ctEntry.getModelClassPK());
                sb.append(", ");
            }
            sb.setStringAt(")", sb.index() - 1);
            Connection connection = CurrentConnectionUtil.getConnection((DataSource)ctPersistence.getDataSource());
            try (PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());){
                preparedStatement.executeUpdate();
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            for (String mappingTableName : ctPersistence.getMappingTableNames()) {
                sb.setStringAt(mappingTableName, 1);
                try {
                    PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());
                    Throwable throwable = null;
                    try {
                        preparedStatement.executeUpdate();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (preparedStatement == null) continue;
                        if (throwable != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    throw new SystemException((Throwable)exception);
                }
            }
            return null;
        });
        ArrayList<Long> modelClassPKs = new ArrayList<Long>(ctEntries.size());
        for (CTEntry ctEntry : ctEntries) {
            modelClassPKs.add(ctEntry.getModelClassPK());
            this.ctEntryPersistence.remove((BaseModel)ctEntry);
        }
        for (CTAutoResolutionInfo ctAutoResolutionInfo : this._ctAutoResolutionInfoPersistence.findByC_MCNI_SMCPK(ctCollection.getCtCollectionId(), classNameId, ArrayUtil.toLongArray(modelClassPKs))) {
            this._ctAutoResolutionInfoPersistence.remove((BaseModel)ctAutoResolutionInfo);
        }
        Indexer indexer = this._indexerRegistry.getIndexer(ctService.getModelClass());
        if (indexer != null) {
            TransactionCommitCallbackUtil.registerCallback(() -> {
                ArrayList<String> uids = new ArrayList<String>(ctEntries.size());
                for (CTEntry ctEntry : ctEntries) {
                    if (ctEntry.getChangeType() == 1) continue;
                    uids.add(this._uidFactory.getUID(indexer.getClassName(), (Serializable)Long.valueOf(ctEntry.getModelClassPK()), ctEntry.getCtCollectionId()));
                }
                this._indexWriterHelper.deleteDocuments(indexer.getSearchEngineId(), ctCollection.getCompanyId(), uids, indexer.isCommitImmediately());
                return null;
            });
        }
    }

    private Predicate _getPredicate(long companyId, int[] statuses, String keywords) {
        Predicate predicate = CTCollectionTable.INSTANCE.companyId.eq((Object)companyId);
        if (!ArrayUtil.isEmpty((int[])statuses)) {
            predicate = predicate.and((Expression)CTCollectionTable.INSTANCE.status.in((Object[])ArrayUtil.toArray((int[])statuses)));
        }
        String[] keywordsArray = this._customSQL.keywords(keywords, true, WildcardMode.SURROUND);
        predicate = predicate.and((Expression)Predicate.withParentheses((Predicate)Predicate.or((Predicate)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)CTCollectionTable.INSTANCE.name), keywordsArray), (Predicate)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)CTCollectionTable.INSTANCE.description), keywordsArray))));
        Predicate permissionWherePredicate = this._inlineSQLHelper.getPermissionWherePredicate(CTCollection.class, CTCollectionTable.INSTANCE.ctCollectionId, new long[0]);
        if (permissionWherePredicate == null) {
            return predicate;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        return predicate.and((Expression)permissionWherePredicate.or((Expression)CTCollectionTable.INSTANCE.ctCollectionId.in((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{GroupTable.INSTANCE.classPK}).from((Table)GroupTable.INSTANCE).innerJoinON((Table)UserGroupRoleTable.INSTANCE, UserGroupRoleTable.INSTANCE.groupId.eq((Expression)GroupTable.INSTANCE.groupId)).where(GroupTable.INSTANCE.companyId.eq((Object)permissionChecker.getCompanyId()).and((Expression)GroupTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(CTCollection.class.getName()))).and((Expression)UserGroupRoleTable.INSTANCE.userId.eq((Object)permissionChecker.getUserId()))))));
    }
}

