/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.exception.CTStagingEnabledException;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTPreferences;
import com.liferay.change.tracking.model.CTPreferencesTable;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTPreferencesLocalService;
import com.liferay.change.tracking.service.base.CTPreferencesServiceBaseImpl;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupTable;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.PortletPermission;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=ct", "json.web.service.context.path=CTPreferences"}, service={AopService.class})
public class CTPreferencesServiceImpl
extends CTPreferencesServiceBaseImpl {
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference(target="(model.class.name=com.liferay.change.tracking.model.CTCollection)")
    private ModelResourcePermission<CTCollection> _ctCollectionModelResourcePermission;
    @Reference
    private CTPreferencesLocalService _ctPreferencesLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private PortletPermission _portletPermission;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public CTPreferences checkoutCTCollection(long companyId, long userId, long ctCollectionId) throws PortalException {
        CTPreferences ctPreferences;
        long currentCtCollectionId;
        if (userId == 0L) {
            return this.enablePublications(companyId, true);
        }
        if (ctCollectionId != 0L) {
            CTCollection ctCollection = this._ctCollectionLocalService.fetchCTCollection(ctCollectionId);
            if (ctCollection == null || ctCollection.getStatus() != 2) {
                return null;
            }
            this._ctCollectionModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ctCollection, "UPDATE");
        }
        if ((currentCtCollectionId = (ctPreferences = this.ctPreferencesLocalService.getCTPreferences(companyId, userId)).getCtCollectionId()) != ctCollectionId) {
            ctPreferences.setCtCollectionId(ctCollectionId);
            if (ctCollectionId == 0L) {
                ctPreferences.setPreviousCtCollectionId(currentCtCollectionId);
            } else {
                ctPreferences.setPreviousCtCollectionId(0L);
            }
            ctPreferences = (CTPreferences)this.ctPreferencesPersistence.update((BaseModel)ctPreferences);
        }
        return ctPreferences;
    }

    public CTPreferences enablePublications(long companyId, boolean enable) throws PortalException {
        this._portletPermission.check(this.getPermissionChecker(), "com_liferay_change_tracking_web_portlet_PublicationsConfigurationPortlet", "CONFIGURATION");
        if (enable) {
            for (Group group : (List)this._groupLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)GroupTable.INSTANCE).from((Table)GroupTable.INSTANCE).where(GroupTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)GroupTable.INSTANCE.liveGroupId.neq((Object)0L).or((Expression)GroupTable.INSTANCE.typeSettings.like("%staged=true%")).withParentheses())))) {
                if (!group.isStaged() && !group.isStagingGroup()) continue;
                throw new CTStagingEnabledException();
            }
            Role role = this._roleLocalService.getRole(companyId, "Publications User");
            this._resourcePermissionLocalService.addResourcePermission(companyId, "com_liferay_change_tracking_web_portlet_PublicationsPortlet", 1, String.valueOf(companyId), role.getRoleId(), "ACCESS_IN_CONTROL_PANEL");
            this._resourcePermissionLocalService.addResourcePermission(companyId, "com_liferay_change_tracking_web_portlet_PublicationsPortlet", 1, String.valueOf(companyId), role.getRoleId(), "VIEW");
            return this._ctPreferencesLocalService.getCTPreferences(companyId, 0L);
        }
        for (CTPreferences ctPreferences : (List)this.ctPreferencesPersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)CTPreferencesTable.INSTANCE).from((Table)CTPreferencesTable.INSTANCE).where(CTPreferencesTable.INSTANCE.companyId.eq((Object)companyId)))) {
            this.ctPreferencesPersistence.remove((BaseModel)ctPreferences);
        }
        return null;
    }
}

