/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.spi.display;

import com.liferay.change.tracking.spi.display.CTDisplayRenderer;
import com.liferay.change.tracking.spi.display.context.DisplayContext;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.sql.Blob;
import java.text.Format;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseCTDisplayRenderer<T extends BaseModel<T>>
implements CTDisplayRenderer<T> {
    private static final Log _log = LogFactoryUtil.getLog(BaseCTDisplayRenderer.class);

    @Override
    @Deprecated
    public String getEditURL(HttpServletRequest httpServletRequest, CTModel<?> ctModel) throws Exception {
        return this.getEditURL(httpServletRequest, (T)ctModel);
    }

    @Override
    public String getEditURL(HttpServletRequest httpServletRequest, T model) throws Exception {
        return null;
    }

    @Override
    public abstract Class<T> getModelClass();

    @Override
    @Deprecated
    public String getTitle(Locale locale, CTModel<?> ctModel) throws PortalException {
        return this.getTitle(locale, (T)ctModel);
    }

    @Override
    public abstract String getTitle(Locale var1, T var2) throws PortalException;

    @Override
    public String getTypeName(Locale locale) {
        Class<T> modelClass = this.getModelClass();
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(locale), (String)("model.resource." + modelClass.getName()), (String)modelClass.getName());
    }

    @Override
    @Deprecated
    public boolean isHideable(CTModel<?> ctModel) {
        return this.isHideable((T)ctModel);
    }

    @Override
    public boolean isHideable(T model) {
        return false;
    }

    @Override
    public void render(DisplayContext<T> displayContext) throws Exception {
        HttpServletResponse httpServletResponse = displayContext.getHttpServletResponse();
        PrintWriter writer = httpServletResponse.getWriter();
        ((Writer)writer).write("<div class=\"table-responsive\"><table class=\"");
        ((Writer)writer).write("publications-render-table table table-autofit ");
        ((Writer)writer).write("table-nowrap\">");
        HttpServletRequest httpServletRequest = displayContext.getHttpServletRequest();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this.buildDisplay(new DisplayBuilderImpl(displayContext, this.getResourceBundle(displayContext.getLocale()), themeDisplay));
        ((Writer)writer).write("</table></div>");
    }

    protected void buildDisplay(DisplayBuilder<T> displayBuilder) throws PortalException {
        BaseModel model = (BaseModel)displayBuilder.getModel();
        Map attributeGetterFunctions = model.getAttributeGetterFunctions();
        for (Map.Entry entry : attributeGetterFunctions.entrySet()) {
            Function function = (Function)entry.getValue();
            displayBuilder.display(CamelCaseUtil.fromCamelCase((String)((String)entry.getKey())), function.apply(model));
        }
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((Locale)locale, this.getClass());
    }

    private static class DisplayBuilderImpl<T>
    implements DisplayBuilder<T> {
        private final DisplayContext<T> _displayContext;
        private final ResourceBundle _resourceBundle;
        private final ThemeDisplay _themeDisplay;

        @Override
        public DisplayBuilder<T> display(String languageKey, Object value) {
            HttpServletResponse httpServletResponse = this._displayContext.getHttpServletResponse();
            try {
                PrintWriter writer = httpServletResponse.getWriter();
                ((Writer)writer).write("<tr><td class=\"publications-key-td ");
                ((Writer)writer).write("table-cell-expand-small\">");
                ((Writer)writer).write(LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)languageKey));
                ((Writer)writer).write("</td><td class=\"table-cell-expand\">");
                if (value instanceof Blob) {
                    String downloadURL = this._displayContext.getDownloadURL(languageKey, 0L, null);
                    if (downloadURL == null) {
                        ((Writer)writer).write(LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"no-download"));
                    } else {
                        ((Writer)writer).write("<a href=\"");
                        ((Writer)writer).write(downloadURL);
                        ((Writer)writer).write("\" >");
                        ((Writer)writer).write(LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"download"));
                        ((Writer)writer).write("</a>");
                    }
                } else if (value instanceof Date) {
                    Format format = FastDateFormatFactoryUtil.getDateTime((Locale)this._resourceBundle.getLocale(), (TimeZone)this._themeDisplay.getTimeZone());
                    ((Writer)writer).write(format.format(value));
                } else {
                    ((Writer)writer).write(HtmlUtil.escape((String)String.valueOf(value)));
                }
                ((Writer)writer).write("</td></tr>");
            }
            catch (IOException ioException) {
                throw new UncheckedIOException(ioException);
            }
            return this;
        }

        @Override
        public DisplayBuilder<T> display(String languageKey, String value, boolean escape) {
            HttpServletResponse httpServletResponse = this._displayContext.getHttpServletResponse();
            try {
                PrintWriter writer = httpServletResponse.getWriter();
                ((Writer)writer).write("<tr><td class=\"publications-key-td ");
                ((Writer)writer).write("table-cell-expand-small\">");
                ((Writer)writer).write(LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)languageKey));
                ((Writer)writer).write("</td><td class=\"table-cell-expand\">");
                if (escape) {
                    value = HtmlUtil.escape((String)value);
                }
                ((Writer)writer).write(value);
                ((Writer)writer).write("</td></tr>");
            }
            catch (IOException ioException) {
                throw new UncheckedIOException(ioException);
            }
            return this;
        }

        @Override
        public DisplayBuilder<T> display(String languageKey, UnsafeSupplier<Object, Exception> unsafeSupplier) {
            block3: {
                try {
                    Object value = unsafeSupplier.get();
                    if (value != null) {
                        this.display(languageKey, value);
                    }
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Throwable)exception);
                }
            }
            return this;
        }

        @Override
        public DisplayContext<T> getDisplayContext() {
            return this._displayContext;
        }

        @Override
        public Locale getLocale() {
            return this._resourceBundle.getLocale();
        }

        @Override
        public T getModel() {
            return this._displayContext.getModel();
        }

        private DisplayBuilderImpl(DisplayContext<T> displayContext, ResourceBundle resourceBundle, ThemeDisplay themeDisplay) {
            this._displayContext = displayContext;
            this._resourceBundle = resourceBundle;
            this._themeDisplay = themeDisplay;
        }
    }

    protected static interface DisplayBuilder<T> {
        public DisplayBuilder<T> display(String var1, Object var2);

        public DisplayBuilder<T> display(String var1, String var2, boolean var3);

        public DisplayBuilder<T> display(String var1, UnsafeSupplier<Object, Exception> var2);

        public DisplayContext<T> getDisplayContext();

        public Locale getLocale();

        public T getModel();
    }
}

