/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.test.util;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTCollectionService;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.test.rule.Inject;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseTableReferenceDefinitionTestCase {
    @DeleteAfterTestRun
    protected Group group;
    @Inject
    private static ClassNameLocalService _classNameLocalService;
    @Inject
    private static CTCollectionLocalService _ctCollectionLocalService;
    @Inject
    private static CTCollectionService _ctCollectionService;
    @Inject
    private static CTEntryLocalService _ctEntryLocalService;
    @DeleteAfterTestRun
    private CTCollection _ctCollection;

    @Before
    public void setUp() throws Exception {
        this.group = GroupTestUtil.addGroup();
    }

    @Test
    public void testDiscardCTEntry() throws Exception {
        this._ctCollection = _ctCollectionService.addCTCollection(TestPropsValues.getCompanyId(), TestPropsValues.getUserId(), RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]), RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]));
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)this._ctCollection.getCtCollectionId());){
            CTModel<?> ctModel = this.addCTModel();
            int count = _ctEntryLocalService.getCTCollectionCTEntriesCount(this._ctCollection.getCtCollectionId());
            Assert.assertTrue((count > 0 ? 1 : 0) != 0);
            long modelClassNameId = _classNameLocalService.getClassNameId(ctModel.getModelClass());
            CTEntry ctEntry = _ctEntryLocalService.fetchCTEntry(this._ctCollection.getCtCollectionId(), modelClassNameId, ctModel.getPrimaryKey());
            Assert.assertNotNull((Object)ctEntry);
            List ctEntries = _ctCollectionLocalService.getDiscardCTEntries(this._ctCollection.getCtCollectionId(), modelClassNameId, ctModel.getPrimaryKey());
            Assert.assertTrue((String)ctEntries.toString(), (boolean)ctEntries.contains(ctEntry));
            _ctCollectionService.discardCTEntry(this._ctCollection.getCtCollectionId(), _classNameLocalService.getClassNameId(ctModel.getModelClass()), ctModel.getPrimaryKey());
            count = _ctEntryLocalService.getCTCollectionCTEntriesCount(this._ctCollection.getCtCollectionId());
            Assert.assertEquals((long)0L, (long)count);
        }
    }

    protected abstract CTModel<?> addCTModel() throws Exception;
}

