Liferay.Loader.define("change-tracking-web@1.0.46/dynamic_include/ChangeTrackingIndicator", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = _default;

    var _dropDown = require("@frontend-taglib-clay$clayui/drop-down");

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _frontendJsWeb = require("frontend-js-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var Component = function Component(_ref) {
      var checkoutURL = _ref.checkoutURL,
          iconClass = _ref.iconClass,
          iconName = _ref.iconName,
          items = _ref.items,
          namespace = _ref.namespace,
          selectURL = _ref.selectURL,
          title = _ref.title;

      var onSelectPublication = function onSelectPublication() {
        (0, _frontendJsWeb.openSelectionModal)({
          onSelect: function onSelect(event) {
            var portletURL = (0, _frontendJsWeb.createPortletURL)(checkoutURL, {
              ctCollectionId: event.ctcollectionid
            });
            (0, _frontendJsWeb.navigate)(portletURL.toString());
          },
          selectEventName: namespace + 'selectPublication',
          title: Liferay.Language.get('select-a-publication'),
          url: selectURL
        });
      };

      Liferay.on('destroyPortlet', function onDestroyPortlet() {
        Liferay.detach('destroyPortlet', onDestroyPortlet);
        Liferay.detach(namespace + 'openDialog', onSelectPublication);
      });
      Liferay.on(namespace + 'openDialog', onSelectPublication);
      return (/*#__PURE__*/_react.default.createElement(_dropDown.ClayDropDownWithItems, {
          alignmentPosition: _dropDown.Align.BottomCenter,
          items: items,
          trigger: /*#__PURE__*/_react.default.createElement("button", {
            className: "change-tracking-indicator-button"
          }, /*#__PURE__*/_react.default.createElement(_icon.default, {
            className: iconClass,
            symbol: iconName
          }), /*#__PURE__*/_react.default.createElement("span", {
            className: "change-tracking-indicator-title"
          }, title), /*#__PURE__*/_react.default.createElement(_icon.default, {
            symbol: "caret-bottom"
          }))
        })
      );
    };

    function _default(props) {
      return (/*#__PURE__*/_react.default.createElement(Component, props)
      );
    }
    //# sourceMappingURL=ChangeTrackingIndicator.js.map
  }
});
//# sourceMappingURL=ChangeTrackingIndicator.js.map