"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/_lib/setUTCISODay/index", ['module', 'exports', 'require', '../toInteger/index', '../../toDate/index', '../requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = setUTCISODay;

    var _index = _interopRequireDefault(require("../toInteger/index"));

    var _index2 = _interopRequireDefault(require("../../toDate/index"));

    var _index3 = _interopRequireDefault(require("../requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    // This function will be a part of public API when UTC function will be implemented.
    // See issue: https://github.com/date-fns/date-fns/issues/376
    function setUTCISODay(dirtyDate, dirtyDay) {
      (0, _index3.default)(2, arguments);
      var day = (0, _index.default)(dirtyDay);

      if (day % 7 === 0) {
        day = day - 7;
      }

      var date = (0, _index2.default)(dirtyDate);
      var currentDay = date.getUTCDay();
      var remainder = day % 7;

      var diff = ((remainder + 7) % 7 < 1 ? 7 : 0) + day - currentDay;
      date.setUTCDate(date.getUTCDate() + diff);
      return date;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map