"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/differenceInCalendarMonths/index", ['module', 'exports', 'require', '../toDate/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = differenceInCalendarMonths;

    var _index = _interopRequireDefault(require("../toDate/index"));

    var _index2 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name differenceInCalendarMonths
     * @category Month Helpers
     * @summary Get the number of calendar months between the given dates.
     *
     * @description
     * Get the number of calendar months between the given dates.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} dateLeft - the later date
     * @param {Date|Number} dateRight - the earlier date
     * @returns {Number} the number of calendar months
     * @throws {TypeError} 2 arguments required
     *
     * @example
     * // How many calendar months are between 31 January 2014 and 1 September 2014?
     * var result = differenceInCalendarMonths(
     *   new Date(2014, 8, 1),
     *   new Date(2014, 0, 31)
     * )
     * //=> 8
     */
    function differenceInCalendarMonths(dirtyDateLeft, dirtyDateRight) {
      (0, _index2.default)(2, arguments);
      var dateLeft = (0, _index.default)(dirtyDateLeft);
      var dateRight = (0, _index.default)(dirtyDateRight);
      var yearDiff = dateLeft.getFullYear() - dateRight.getFullYear();
      var monthDiff = dateLeft.getMonth() - dateRight.getMonth();
      return yearDiff * 12 + monthDiff;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map