"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/differenceInCalendarQuarters/index", ['module', 'exports', 'require', '../getQuarter/index', '../toDate/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = differenceInCalendarQuarters;

    var _index = _interopRequireDefault(require("../getQuarter/index"));

    var _index2 = _interopRequireDefault(require("../toDate/index"));

    var _index3 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name differenceInCalendarQuarters
     * @category Quarter Helpers
     * @summary Get the number of calendar quarters between the given dates.
     *
     * @description
     * Get the number of calendar quarters between the given dates.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} dateLeft - the later date
     * @param {Date|Number} dateRight - the earlier date
     * @returns {Number} the number of calendar quarters
     * @throws {TypeError} 2 arguments required
     *
     * @example
     * // How many calendar quarters are between 31 December 2013 and 2 July 2014?
     * var result = differenceInCalendarQuarters(
     *   new Date(2014, 6, 2),
     *   new Date(2013, 11, 31)
     * )
     * //=> 3
     */
    function differenceInCalendarQuarters(dirtyDateLeft, dirtyDateRight) {
      (0, _index3.default)(2, arguments);
      var dateLeft = (0, _index2.default)(dirtyDateLeft);
      var dateRight = (0, _index2.default)(dirtyDateRight);
      var yearDiff = dateLeft.getFullYear() - dateRight.getFullYear();
      var quarterDiff = (0, _index.default)(dateLeft) - (0, _index.default)(dateRight);
      return yearDiff * 4 + quarterDiff;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map