"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/differenceInMinutes/index", ['module', 'exports', 'require', '../differenceInMilliseconds/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = differenceInMinutes;

    var _index = _interopRequireDefault(require("../differenceInMilliseconds/index"));

    var _index2 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    var MILLISECONDS_IN_MINUTE = 60000;
    /**
     * @name differenceInMinutes
     * @category Minute Helpers
     * @summary Get the number of minutes between the given dates.
     *
     * @description
     * Get the signed number of full (rounded towards 0) minutes between the given dates.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} dateLeft - the later date
     * @param {Date|Number} dateRight - the earlier date
     * @returns {Number} the number of minutes
     * @throws {TypeError} 2 arguments required
     *
     * @example
     * // How many minutes are between 2 July 2014 12:07:59 and 2 July 2014 12:20:00?
     * var result = differenceInMinutes(
     *   new Date(2014, 6, 2, 12, 20, 0),
     *   new Date(2014, 6, 2, 12, 7, 59)
     * )
     * //=> 12
     *
     * @example
     * // How many minutes are from 10:01:59 to 10:00:00
     * var result = differenceInMinutes(
     *   new Date(2000, 0, 1, 10, 0, 0),
     *   new Date(2000, 0, 1, 10, 1, 59)
     * )
     * //=> -1
     */

    function differenceInMinutes(dirtyDateLeft, dirtyDateRight) {
      (0, _index2.default)(2, arguments);
      var diff = (0, _index.default)(dirtyDateLeft, dirtyDateRight) / MILLISECONDS_IN_MINUTE;
      return diff > 0 ? Math.floor(diff) : Math.ceil(diff);
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map