"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/endOfISOWeek/index", ['module', 'exports', 'require', '../endOfWeek/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = endOfISOWeek;

    var _index = _interopRequireDefault(require("../endOfWeek/index"));

    var _index2 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name endOfISOWeek
     * @category ISO Week Helpers
     * @summary Return the end of an ISO week for the given date.
     *
     * @description
     * Return the end of an ISO week for the given date.
     * The result will be in the local timezone.
     *
     * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the original date
     * @returns {Date} the end of an ISO week
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // The end of an ISO week for 2 September 2014 11:55:00:
     * var result = endOfISOWeek(new Date(2014, 8, 2, 11, 55, 0))
     * //=> Sun Sep 07 2014 23:59:59.999
     */
    function endOfISOWeek(dirtyDate) {
      (0, _index2.default)(1, arguments);
      return (0, _index.default)(dirtyDate, {
        weekStartsOn: 1
      });
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map