"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/endOfMinute/index", ['module', 'exports', 'require', '../toDate/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = endOfMinute;

    var _index = _interopRequireDefault(require("../toDate/index"));

    var _index2 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name endOfMinute
     * @category Minute Helpers
     * @summary Return the end of a minute for the given date.
     *
     * @description
     * Return the end of a minute for the given date.
     * The result will be in the local timezone.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the original date
     * @returns {Date} the end of a minute
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // The end of a minute for 1 December 2014 22:15:45.400:
     * var result = endOfMinute(new Date(2014, 11, 1, 22, 15, 45, 400))
     * //=> Mon Dec 01 2014 22:15:59.999
     */
    function endOfMinute(dirtyDate) {
      (0, _index2.default)(1, arguments);
      var date = (0, _index.default)(dirtyDate);
      date.setSeconds(59, 999);
      return date;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map