Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/_lib/getUTCISOWeek/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import toDate from '../../toDate/index.js';
    import startOfUTCISOWeek from '../startOfUTCISOWeek/index.js';
    import startOfUTCISOWeekYear from '../startOfUTCISOWeekYear/index.js';
    import requiredArgs from '../requiredArgs/index.js';
    var MILLISECONDS_IN_WEEK = 604800000; // This function will be a part of public API when UTC function will be implemented.
    // See issue: https://github.com/date-fns/date-fns/issues/376

    export default function getUTCISOWeek(dirtyDate) {
      requiredArgs(1, arguments);
      var date = toDate(dirtyDate);
      var diff = startOfUTCISOWeek(date).getTime() - startOfUTCISOWeekYear(date).getTime(); // Round the number of days to the nearest integer
      // because the number of milliseconds in a week is not constant
      // (e.g. it's different in the week of the daylight saving time clock shift)

      return Math.round(diff / MILLISECONDS_IN_WEEK) + 1;
    }
  }
});
//# sourceMappingURL=index.js.map