Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/endOfToday/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import endOfDay from '../endOfDay/index.js';
    /**
     * @name endOfToday
     * @category Day Helpers
     * @summary Return the end of today.
     * @pure false
     *
     * @description
     * Return the end of today.
     *
     * > ⚠️ Please note that this function is not present in the FP submodule as
     * > it uses `Date.now()` internally hence impure and can't be safely curried.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @returns {Date} the end of today
     *
     * @example
     * // If today is 6 October 2014:
     * var result = endOfToday()
     * //=> Mon Oct 6 2014 23:59:59.999
     */

    export default function endOfToday() {
      return endOfDay(Date.now());
    }
  }
});
//# sourceMappingURL=index.js.map