Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/getDayOfYear/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import toDate from '../toDate/index.js';
    import startOfYear from '../startOfYear/index.js';
    import differenceInCalendarDays from '../differenceInCalendarDays/index.js';
    import requiredArgs from '../_lib/requiredArgs/index.js';
    /**
     * @name getDayOfYear
     * @category Day Helpers
     * @summary Get the day of the year of the given date.
     *
     * @description
     * Get the day of the year of the given date.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the given date
     * @returns {Number} the day of year
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // Which day of the year is 2 July 2014?
     * var result = getDayOfYear(new Date(2014, 6, 2))
     * //=> 183
     */

    export default function getDayOfYear(dirtyDate) {
      requiredArgs(1, arguments);
      var date = toDate(dirtyDate);
      var diff = differenceInCalendarDays(date, startOfYear(date));

      return diff + 1;
    }
  }
});
//# sourceMappingURL=index.js.map