Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/isSaturday/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import toDate from '../toDate/index.js';
    import requiredArgs from '../_lib/requiredArgs/index.js';
    /**
     * @name isSaturday
     * @category Weekday Helpers
     * @summary Is the given date Saturday?
     *
     * @description
     * Is the given date Saturday?
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the date to check
     * @returns {Boolean} the date is Saturday
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // Is 27 September 2014 Saturday?
     * var result = isSaturday(new Date(2014, 8, 27))
     * //=> true
     */

    export default function isSaturday(dirtyDate) {
      requiredArgs(1, arguments);
      return toDate(dirtyDate).getDay() === 6;
    }
  }
});
//# sourceMappingURL=index.js.map