Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/isThisSecond/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import isSameSecond from '../isSameSecond/index.js';
    import requiredArgs from '../_lib/requiredArgs/index.js';
    /**
     * @name isThisSecond
     * @category Second Helpers
     * @summary Is the given date in the same second as the current date?
     * @pure false
     *
     * @description
     * Is the given date in the same second as the current date?
     *
     * > ⚠️ Please note that this function is not present in the FP submodule as
     * > it uses `Date.now()` internally hence impure and can't be safely curried.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the date to check
     * @returns {Boolean} the date is in this second
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // If now is 25 September 2014 18:30:15.500,
     * // is 25 September 2014 18:30:15.000 in this second?
     * var result = isThisSecond(new Date(2014, 8, 25, 18, 30, 15))
     * //=> true
     */

    export default function isThisSecond(dirtyDate) {
      requiredArgs(1, arguments);
      return isSameSecond(Date.now(), dirtyDate);
    }
  }
});
//# sourceMappingURL=index.js.map