Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/locale/hu/_lib/formatRelative/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var accusativeWeekdays = ['vasárnap', 'hétfőn', 'kedden', 'szerdán', 'csütörtökön', 'pénteken', 'szombaton'];

    function week(isFuture) {
      return function (date, _baseDate, _options) {
        var day = date.getUTCDay();
        return (isFuture ? '' : "'múlt' ") + "'" + accusativeWeekdays[day] + "'" + " p'-kor'";
      };
    }

    var formatRelativeLocale = {
      lastWeek: week(false),
      yesterday: "'tegnap' p'-kor'",
      today: "'ma' p'-kor'",
      tomorrow: "'holnap' p'-kor'",
      nextWeek: week(true),
      other: 'P'
    };
    export default function formatRelative(token, date, baseDate, options) {
      var format = formatRelativeLocale[token];

      if (typeof format === 'function') {
        return format(date, baseDate, options);
      }

      return format;
    }
  }
});
//# sourceMappingURL=index.js.map