Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/locale/ko/_lib/match/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import buildMatchPatternFn from '../../../_lib/buildMatchPatternFn/index.js';
    import buildMatchFn from '../../../_lib/buildMatchFn/index.js';
    var matchOrdinalNumberPattern = /^(\d+)(일|번째)?/i;
    var parseOrdinalNumberPattern = /\d+/i;
    var matchEraPatterns = {
      narrow: /^(b\.?\s?c\.?|b\.?\s?c\.?\s?e\.?|a\.?\s?d\.?|c\.?\s?e\.?)/i,
      abbreviated: /^(b\.?\s?c\.?|b\.?\s?c\.?\s?e\.?|a\.?\s?d\.?|c\.?\s?e\.?)/i,
      wide: /^(기원전|서기)/i
    };
    var parseEraPatterns = {
      any: [/^(bc|기원전)/i, /^(ad|서기)/i]
    };
    var matchQuarterPatterns = {
      narrow: /^[1234]/i,
      abbreviated: /^q[1234]/i,
      wide: /^[1234]사?분기/i
    };
    var parseQuarterPatterns = {
      any: [/1/i, /2/i, /3/i, /4/i]
    };
    var matchMonthPatterns = {
      narrow: /^(1[012]|[123456789])/,
      abbreviated: /^(1[012]|[123456789])월/i,
      wide: /^(1[012]|[123456789])월/i
    };
    var parseMonthPatterns = {
      any: [/^1월?$/, /^2/, /^3/, /^4/, /^5/, /^6/, /^7/, /^8/, /^9/, /^10/, /^11/, /^12/]
    };
    var matchDayPatterns = {
      narrow: /^[일월화수목금토]/,
      short: /^[일월화수목금토]/,
      abbreviated: /^[일월화수목금토]/,
      wide: /^[일월화수목금토]요일/
    };
    var parseDayPatterns = {
      any: [/^일/, /^월/, /^화/, /^수/, /^목/, /^금/, /^토/]
    };
    var matchDayPeriodPatterns = {
      any: /^(am|pm|오전|오후|자정|정오|아침|저녁|밤)/i
    };
    var parseDayPeriodPatterns = {
      any: {
        am: /^(am|오전)/i,
        pm: /^(pm|오후)/i,
        midnight: /^자정/i,
        noon: /^정오/i,
        morning: /^아침/i,
        afternoon: /^오후/i,
        evening: /^저녁/i,
        night: /^밤/i
      }
    };
    var match = {
      ordinalNumber: buildMatchPatternFn({
        matchPattern: matchOrdinalNumberPattern,
        parsePattern: parseOrdinalNumberPattern,
        valueCallback: function (value) {
          return parseInt(value, 10);
        }
      }),
      era: buildMatchFn({
        matchPatterns: matchEraPatterns,
        defaultMatchWidth: 'wide',
        parsePatterns: parseEraPatterns,
        defaultParseWidth: 'any'
      }),
      quarter: buildMatchFn({
        matchPatterns: matchQuarterPatterns,
        defaultMatchWidth: 'wide',
        parsePatterns: parseQuarterPatterns,
        defaultParseWidth: 'any',
        valueCallback: function (index) {
          return index + 1;
        }
      }),
      month: buildMatchFn({
        matchPatterns: matchMonthPatterns,
        defaultMatchWidth: 'wide',
        parsePatterns: parseMonthPatterns,
        defaultParseWidth: 'any'
      }),
      day: buildMatchFn({
        matchPatterns: matchDayPatterns,
        defaultMatchWidth: 'wide',
        parsePatterns: parseDayPatterns,
        defaultParseWidth: 'any'
      }),
      dayPeriod: buildMatchFn({
        matchPatterns: matchDayPeriodPatterns,
        defaultMatchWidth: 'any',
        parsePatterns: parseDayPeriodPatterns,
        defaultParseWidth: 'any'
      })
    };
    export default match;
  }
});
//# sourceMappingURL=index.js.map