Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/locale/pt-BR/_lib/localize/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import buildLocalizeFn from '../../../_lib/buildLocalizeFn/index.js';
    var eraValues = {
      narrow: ['AC', 'DC'],
      abbreviated: ['AC', 'DC'],
      wide: ['antes de cristo', 'depois de cristo']
    };
    var quarterValues = {
      narrow: ['1', '2', '3', '4'],
      abbreviated: ['T1', 'T2', 'T3', 'T4'],
      wide: ['1º trimestre', '2º trimestre', '3º trimestre', '4º trimestre']
    };
    var monthValues = {
      narrow: ['j', 'f', 'm', 'a', 'm', 'j', 'j', 'a', 's', 'o', 'n', 'd'],
      abbreviated: ['jan', 'fev', 'mar', 'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'out', 'nov', 'dez'],
      wide: ['janeiro', 'fevereiro', 'março', 'abril', 'maio', 'junho', 'julho', 'agosto', 'setembro', 'outubro', 'novembro', 'dezembro']
    };
    var dayValues = {
      narrow: ['do', '2ª', '3ª', '4ª', '5ª', '6ª', 'sá'],
      short: ['do', '2ª', '3ª', '4ª', '5ª', '6ª', 'sá'],
      abbreviated: ['dom', 'seg', 'ter', 'qua', 'qui', 'sex', 'sáb'],
      wide: ['domingo', 'segunda', 'terça', 'quarta', 'quinta', 'sexta', 'sábado']
    };
    var dayPeriodValues = {
      narrow: {
        am: 'a',
        pm: 'p',
        midnight: 'mn',
        noon: 'md',
        morning: 'manhã',
        afternoon: 'tarde',
        evening: 'tarde',
        night: 'noite'
      },
      abbreviated: {
        am: 'AM',
        pm: 'PM',
        midnight: 'meia-noite',
        noon: 'meio-dia',
        morning: 'manhã',
        afternoon: 'tarde',
        evening: 'tarde',
        night: 'noite'
      },
      wide: {
        am: 'a.m.',
        pm: 'p.m.',
        midnight: 'meia-noite',
        noon: 'meio-dia',
        morning: 'manhã',
        afternoon: 'tarde',
        evening: 'tarde',
        night: 'noite'
      }
    };
    var formattingDayPeriodValues = {
      narrow: {
        am: 'a',
        pm: 'p',
        midnight: 'mn',
        noon: 'md',
        morning: 'da manhã',
        afternoon: 'da tarde',
        evening: 'da tarde',
        night: 'da noite'
      },
      abbreviated: {
        am: 'AM',
        pm: 'PM',
        midnight: 'meia-noite',
        noon: 'meio-dia',
        morning: 'da manhã',
        afternoon: 'da tarde',
        evening: 'da tarde',
        night: 'da noite'
      },
      wide: {
        am: 'a.m.',
        pm: 'p.m.',
        midnight: 'meia-noite',
        noon: 'meio-dia',
        morning: 'da manhã',
        afternoon: 'da tarde',
        evening: 'da tarde',
        night: 'da noite'
      }
    };

    function ordinalNumber(dirtyNumber, dirtyOptions) {
      var number = Number(dirtyNumber);

      var unit = String((dirtyOptions || {}).unit);

      if (unit === 'week' || unit === 'isoWeek') {
        return number + 'ª';
      }

      return number + 'º';
    }

    var localize = {
      ordinalNumber: ordinalNumber,
      era: buildLocalizeFn({
        values: eraValues,
        defaultWidth: 'wide'
      }),
      quarter: buildLocalizeFn({
        values: quarterValues,
        defaultWidth: 'wide',
        argumentCallback: function (quarter) {
          return Number(quarter) - 1;
        }
      }),
      month: buildLocalizeFn({
        values: monthValues,
        defaultWidth: 'wide'
      }),
      day: buildLocalizeFn({
        values: dayValues,
        defaultWidth: 'wide'
      }),
      dayPeriod: buildLocalizeFn({
        values: dayPeriodValues,
        defaultWidth: 'wide',
        formattingValues: formattingDayPeriodValues,
        defaultFormattingWidth: 'wide'
      })
    };
    export default localize;
  }
});
//# sourceMappingURL=index.js.map