Liferay.Loader.define('change-tracking-web$date-fns@2.14.0/esm/subBusinessDays/index', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import toInteger from '../_lib/toInteger/index.js';
    import addBusinessDays from '../addBusinessDays/index.js';
    import requiredArgs from '../_lib/requiredArgs/index.js';
    /**
     * @name subBusinessDays
     * @category Day Helpers
     * @summary Substract the specified number of business days (mon - fri) to the given date.
     *
     * @description
     * Substract the specified number of business days (mon - fri) to the given date, ignoring weekends.
     *
     * @param {Date|Number} date - the date to be changed
     * @param {Number} amount - the amount of business days to be subtracted. Positive decimals will be rounded using `Math.floor`, decimals less than zero will be rounded using `Math.ceil`.
     * @returns {Date} the new date with the business days subtracted
     * @throws {TypeError} 2 arguments required
     *
     * @example
     * // Substract 10 business days from 1 September 2014:
     * var result = subBusinessDays(new Date(2014, 8, 1), 10)
     * //=> Mon Aug 18 2014 00:00:00 (skipped weekend days)
     */

    export default function subBusinessDays(dirtyDate, dirtyAmount) {
      requiredArgs(2, arguments);
      var amount = toInteger(dirtyAmount);
      return addBusinessDays(dirtyDate, -amount);
    }
  }
});
//# sourceMappingURL=index.js.map