"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/formatISO9075/index", ['module', 'exports', 'require', '../toDate/index', '../isValid/index', '../_lib/addLeadingZeros/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = formatISO9075;

    var _index = _interopRequireDefault(require("../toDate/index"));

    var _index2 = _interopRequireDefault(require("../isValid/index"));

    var _index3 = _interopRequireDefault(require("../_lib/addLeadingZeros/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name formatISO9075
     * @category Common Helpers
     * @summary Format the date according to the ISO 9075 standard (https://dev.mysql.com/doc/refman/5.7/en/date-and-time-functions.html#function_get-format).
     *
     * @description
     * Return the formatted date string in ISO 9075 format. Options may be passed to control the parts and notations of the date.
     *
     * @param {Date|Number} date - the original date
     * @param {Object} [options] - an object with options.
     * @param {'extended'|'basic'} [options.format='extended'] - if 'basic', hide delimiters between date and time values.
     * @param {'complete'|'date'|'time'} [options.representation='complete'] - format date, time, or both.
     * @returns {String} the formatted date string
     * @throws {TypeError} 1 argument required
     * @throws {RangeError} `date` must not be Invalid Date
     * @throws {RangeError} `options.format` must be 'extended' or 'basic'
     * @throws {RangeError} `options.represenation` must be 'date', 'time' or 'complete'
     *
     * @example
     * // Represent 18 September 2019 in ISO 9075 format:
     * const result = formatISO9075(new Date(2019, 8, 18, 19, 0, 52))
     * //=> '2019-09-18 19:00:52'
     *
     * @example
     * // Represent 18 September 2019 in ISO 9075, short format:
     * const result = formatISO9075(new Date(2019, 8, 18, 19, 0, 52), { format: 'basic' })
     * //=> '20190918 190052'
     *
     * @example
     * // Represent 18 September 2019 in ISO 9075 format, date only:
     * const result = formatISO9075(new Date(2019, 8, 18, 19, 0, 52), { representation: 'date' })
     * //=> '2019-09-18'
     *
     * @example
     * // Represent 18 September 2019 in ISO 9075 format, time only:
     * const result = formatISO9075(new Date(2019, 8, 18, 19, 0, 52), { representation: 'time' })
     * //=> '19:00:52'
     */
    function formatISO9075(dirtyDate, dirtyOptions) {
      if (arguments.length < 1) {
        throw new TypeError("1 argument required, but only ".concat(arguments.length, " present"));
      }

      var originalDate = (0, _index.default)(dirtyDate);

      if (!(0, _index2.default)(originalDate)) {
        throw new RangeError('Invalid time value');
      }

      var options = dirtyOptions || {};
      var format = options.format == null ? 'extended' : String(options.format);
      var representation = options.representation == null ? 'complete' : String(options.representation);

      if (format !== 'extended' && format !== 'basic') {
        throw new RangeError("format must be 'extended' or 'basic'");
      }

      if (representation !== 'date' && representation !== 'time' && representation !== 'complete') {
        throw new RangeError("representation must be 'date', 'time', or 'complete'");
      }

      var result = '';
      var dateDelimiter = format === 'extended' ? '-' : '';
      var timeDelimiter = format === 'extended' ? ':' : ''; // Representation is either 'date' or 'complete'

      if (representation !== 'time') {
        var day = (0, _index3.default)(originalDate.getDate(), 2);
        var month = (0, _index3.default)(originalDate.getMonth() + 1, 2);
        var year = (0, _index3.default)(originalDate.getFullYear(), 4); // yyyyMMdd or yyyy-MM-dd.

        result = "".concat(year).concat(dateDelimiter).concat(month).concat(dateDelimiter).concat(day);
      } // Representation is either 'time' or 'complete'


      if (representation !== 'date') {
        var hour = (0, _index3.default)(originalDate.getHours(), 2);
        var minute = (0, _index3.default)(originalDate.getMinutes(), 2);
        var second = (0, _index3.default)(originalDate.getSeconds(), 2); // If there's also date, separate it with time with a space

        var separator = result === '' ? '' : ' '; // HHmmss or HH:mm:ss.

        result = "".concat(result).concat(separator).concat(hour).concat(timeDelimiter).concat(minute).concat(timeDelimiter).concat(second);
      }

      return result;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map