"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/fromUnixTime/index", ['module', 'exports', 'require', '../toDate/index', '../_lib/toInteger/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = fromUnixTime;

    var _index = _interopRequireDefault(require("../toDate/index"));

    var _index2 = _interopRequireDefault(require("../_lib/toInteger/index"));

    var _index3 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name fromUnixTime
     * @category Timestamp Helpers
     * @summary Create a date from a Unix timestamp.
     *
     * @description
     * Create a date from a Unix timestamp.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Number} unixTime - the given Unix timestamp
     * @returns {Date} the date
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // Create the date 29 February 2012 11:45:05:
     * var result = fromUnixTime(1330515905)
     * //=> Wed Feb 29 2012 11:45:05
     */
    function fromUnixTime(dirtyUnixTime) {
      (0, _index3.default)(1, arguments);
      var unixTime = (0, _index2.default)(dirtyUnixTime);
      return (0, _index.default)(unixTime * 1000);
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map