"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/getDate/index", ['module', 'exports', 'require', '../toDate/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = getDate;

    var _index = _interopRequireDefault(require("../toDate/index"));

    var _index2 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name getDate
     * @category Day Helpers
     * @summary Get the day of the month of the given date.
     *
     * @description
     * Get the day of the month of the given date.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the given date
     * @returns {Number} the day of month
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // Which day of the month is 29 February 2012?
     * var result = getDate(new Date(2012, 1, 29))
     * //=> 29
     */
    function getDate(dirtyDate) {
      (0, _index2.default)(1, arguments);
      var date = (0, _index.default)(dirtyDate);
      var dayOfMonth = date.getDate();
      return dayOfMonth;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map