"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/getDay/index", ['module', 'exports', 'require', '../toDate/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = getDay;

    var _index = _interopRequireDefault(require("../toDate/index"));

    var _index2 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name getDay
     * @category Weekday Helpers
     * @summary Get the day of the week of the given date.
     *
     * @description
     * Get the day of the week of the given date.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the given date
     * @returns {0|1|2|3|4|5|6} the day of week
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // Which day of the week is 29 February 2012?
     * var result = getDay(new Date(2012, 1, 29))
     * //=> 3
     */
    function getDay(dirtyDate) {
      (0, _index2.default)(1, arguments);
      var date = (0, _index.default)(dirtyDate);
      var day = date.getDay();
      return day;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map