"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/getDayOfYear/index", ['module', 'exports', 'require', '../toDate/index', '../startOfYear/index', '../differenceInCalendarDays/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = getDayOfYear;

    var _index = _interopRequireDefault(require("../toDate/index"));

    var _index2 = _interopRequireDefault(require("../startOfYear/index"));

    var _index3 = _interopRequireDefault(require("../differenceInCalendarDays/index"));

    var _index4 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name getDayOfYear
     * @category Day Helpers
     * @summary Get the day of the year of the given date.
     *
     * @description
     * Get the day of the year of the given date.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the given date
     * @returns {Number} the day of year
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // Which day of the year is 2 July 2014?
     * var result = getDayOfYear(new Date(2014, 6, 2))
     * //=> 183
     */
    function getDayOfYear(dirtyDate) {
      (0, _index4.default)(1, arguments);
      var date = (0, _index.default)(dirtyDate);
      var diff = (0, _index3.default)(date, (0, _index2.default)(date));

      return diff + 1;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map