"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/getDecade/index", ['module', 'exports', 'require', '../toDate/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = getDecade;

    var _index = _interopRequireDefault(require("../toDate/index"));

    var _index2 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name getDecade
     * @category Decade Helpers
     * @summary Get the decade of the given date.
     *
     * @description
     * Get the decade of the given date.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the given date
     * @returns {Number} the year of decade
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // Which decade belongs 27 November 1942?
     * var result = getDecade(new Date(1942, 10, 27))
     * //=> 1940
     */
    function getDecade(dirtyDate) {
      (0, _index2.default)(1, arguments);
      var date = (0, _index.default)(dirtyDate);
      var year = date.getFullYear();
      var decade = Math.floor(year / 10) * 10;
      return decade;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map