"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/isDate/index", ['module', 'exports', 'require', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = isDate;

    var _index = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name isDate
     * @category Common Helpers
     * @summary Is the given value a date?
     *
     * @description
     * Returns true if the given value is an instance of Date. The function works for dates transferred across iframes.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {*} value - the value to check
     * @returns {boolean} true if the given value is a date
     * @throws {TypeError} 1 arguments required
     *
     * @example
     * // For a valid date:
     * var result = isDate(new Date())
     * //=> true
     *
     * @example
     * // For an invalid date:
     * var result = isDate(new Date(NaN))
     * //=> true
     *
     * @example
     * // For some value:
     * var result = isDate('2014-02-31')
     * //=> false
     *
     * @example
     * // For an object:
     * var result = isDate({})
     * //=> false
     */
    function isDate(value) {
      (0, _index.default)(1, arguments);
      return value instanceof Date || typeof value === 'object' && Object.prototype.toString.call(value) === '[object Date]';
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map