"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/isFriday/index", ['module', 'exports', 'require', '../toDate/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = isFriday;

    var _index = _interopRequireDefault(require("../toDate/index"));

    var _index2 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name isFriday
     * @category Weekday Helpers
     * @summary Is the given date Friday?
     *
     * @description
     * Is the given date Friday?
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the date to check
     * @returns {Boolean} the date is Friday
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // Is 26 September 2014 Friday?
     * var result = isFriday(new Date(2014, 8, 26))
     * //=> true
     */
    function isFriday(dirtyDate) {
      (0, _index2.default)(1, arguments);
      return (0, _index.default)(dirtyDate).getDay() === 5;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map