"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/isFuture/index", ['module', 'exports', 'require', '../toDate/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = isFuture;

    var _index = _interopRequireDefault(require("../toDate/index"));

    var _index2 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name isFuture
     * @category Common Helpers
     * @summary Is the given date in the future?
     * @pure false
     *
     * @description
     * Is the given date in the future?
     *
     * > ⚠️ Please note that this function is not present in the FP submodule as
     * > it uses `Date.now()` internally hence impure and can't be safely curried.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the date to check
     * @returns {Boolean} the date is in the future
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // If today is 6 October 2014, is 31 December 2014 in the future?
     * var result = isFuture(new Date(2014, 11, 31))
     * //=> true
     */
    function isFuture(dirtyDate) {
      (0, _index2.default)(1, arguments);
      return (0, _index.default)(dirtyDate).getTime() > Date.now();
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map