"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/isSameISOWeek/index", ['module', 'exports', 'require', '../isSameWeek/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = isSameISOWeek;

    var _index = _interopRequireDefault(require("../isSameWeek/index"));

    var _index2 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name isSameISOWeek
     * @category ISO Week Helpers
     * @summary Are the given dates in the same ISO week?
     *
     * @description
     * Are the given dates in the same ISO week?
     *
     * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} dateLeft - the first date to check
     * @param {Date|Number} dateRight - the second date to check
     * @returns {Boolean} the dates are in the same ISO week
     * @throws {TypeError} 2 arguments required
     *
     * @example
     * // Are 1 September 2014 and 7 September 2014 in the same ISO week?
     * var result = isSameISOWeek(new Date(2014, 8, 1), new Date(2014, 8, 7))
     * //=> true
     */
    function isSameISOWeek(dirtyDateLeft, dirtyDateRight) {
      (0, _index2.default)(2, arguments);
      return (0, _index.default)(dirtyDateLeft, dirtyDateRight, {
        weekStartsOn: 1
      });
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map