"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/isSameMonth/index", ['module', 'exports', 'require', '../toDate/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = isSameMonth;

    var _index = _interopRequireDefault(require("../toDate/index"));

    var _index2 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name isSameMonth
     * @category Month Helpers
     * @summary Are the given dates in the same month?
     *
     * @description
     * Are the given dates in the same month?
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} dateLeft - the first date to check
     * @param {Date|Number} dateRight - the second date to check
     * @returns {Boolean} the dates are in the same month
     * @throws {TypeError} 2 arguments required
     *
     * @example
     * // Are 2 September 2014 and 25 September 2014 in the same month?
     * var result = isSameMonth(new Date(2014, 8, 2), new Date(2014, 8, 25))
     * //=> true
     */
    function isSameMonth(dirtyDateLeft, dirtyDateRight) {
      (0, _index2.default)(2, arguments);
      var dateLeft = (0, _index.default)(dirtyDateLeft);
      var dateRight = (0, _index.default)(dirtyDateRight);
      return dateLeft.getFullYear() === dateRight.getFullYear() && dateLeft.getMonth() === dateRight.getMonth();
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map