"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/isSameQuarter/index", ['module', 'exports', 'require', '../startOfQuarter/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = isSameQuarter;

    var _index = _interopRequireDefault(require("../startOfQuarter/index"));

    var _index2 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name isSameQuarter
     * @category Quarter Helpers
     * @summary Are the given dates in the same year quarter?
     *
     * @description
     * Are the given dates in the same year quarter?
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} dateLeft - the first date to check
     * @param {Date|Number} dateRight - the second date to check
     * @returns {Boolean} the dates are in the same quarter
     * @throws {TypeError} 2 arguments required
     *
     * @example
     * // Are 1 January 2014 and 8 March 2014 in the same quarter?
     * var result = isSameQuarter(new Date(2014, 0, 1), new Date(2014, 2, 8))
     * //=> true
     */
    function isSameQuarter(dirtyDateLeft, dirtyDateRight) {
      (0, _index2.default)(2, arguments);
      var dateLeftStartOfQuarter = (0, _index.default)(dirtyDateLeft);
      var dateRightStartOfQuarter = (0, _index.default)(dirtyDateRight);
      return dateLeftStartOfQuarter.getTime() === dateRightStartOfQuarter.getTime();
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map