"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/isSameWeek/index", ['module', 'exports', 'require', '../startOfWeek/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = isSameWeek;

    var _index = _interopRequireDefault(require("../startOfWeek/index"));

    var _index2 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name isSameWeek
     * @category Week Helpers
     * @summary Are the given dates in the same week?
     *
     * @description
     * Are the given dates in the same week?
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} dateLeft - the first date to check
     * @param {Date|Number} dateRight - the second date to check
     * @param {Object} [options] - an object with options.
     * @param {Locale} [options.locale=defaultLocale] - the locale object. See [Locale]{@link https://date-fns.org/docs/Locale}
     * @param {0|1|2|3|4|5|6} [options.weekStartsOn=0] - the index of the first day of the week (0 - Sunday)
     * @returns {Boolean} the dates are in the same week
     * @throws {TypeError} 2 arguments required
     * @throws {RangeError} `options.weekStartsOn` must be between 0 and 6
     *
     * @example
     * // Are 31 August 2014 and 4 September 2014 in the same week?
     * var result = isSameWeek(new Date(2014, 7, 31), new Date(2014, 8, 4))
     * //=> true
     *
     * @example
     * // If week starts with Monday,
     * // are 31 August 2014 and 4 September 2014 in the same week?
     * var result = isSameWeek(new Date(2014, 7, 31), new Date(2014, 8, 4), {
     *   weekStartsOn: 1
     * })
     * //=> false
     */
    function isSameWeek(dirtyDateLeft, dirtyDateRight, dirtyOptions) {
      (0, _index2.default)(2, arguments);
      var dateLeftStartOfWeek = (0, _index.default)(dirtyDateLeft, dirtyOptions);
      var dateRightStartOfWeek = (0, _index.default)(dirtyDateRight, dirtyOptions);
      return dateLeftStartOfWeek.getTime() === dateRightStartOfWeek.getTime();
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map