"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/isThisWeek/index", ['module', 'exports', 'require', '../isSameWeek/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = isThisWeek;

    var _index = _interopRequireDefault(require("../isSameWeek/index"));

    var _index2 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name isThisWeek
     * @category Week Helpers
     * @summary Is the given date in the same week as the current date?
     * @pure false
     *
     * @description
     * Is the given date in the same week as the current date?
     *
     * > ⚠️ Please note that this function is not present in the FP submodule as
     * > it uses `Date.now()` internally hence impure and can't be safely curried.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the date to check
     * @param {Object} [options] - the object with options
     * @param {Locale} [options.locale=defaultLocale] - the locale object. See [Locale]{@link https://date-fns.org/docs/Locale}
     * @param {0|1|2|3|4|5|6} [options.weekStartsOn=0] - the index of the first day of the week (0 - Sunday)
     * @returns {Boolean} the date is in this week
     * @throws {TypeError} 1 argument required
     * @throws {RangeError} `options.weekStartsOn` must be between 0 and 6
     *
     * @example
     * // If today is 25 September 2014, is 21 September 2014 in this week?
     * var result = isThisWeek(new Date(2014, 8, 21))
     * //=> true
     *
     * @example
     * // If today is 25 September 2014 and week starts with Monday
     * // is 21 September 2014 in this week?
     * var result = isThisWeek(new Date(2014, 8, 21), { weekStartsOn: 1 })
     * //=> false
     */
    function isThisWeek(dirtyDate, options) {
      (0, _index2.default)(1, arguments);
      return (0, _index.default)(dirtyDate, Date.now(), options);
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map