"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/isThursday/index", ['module', 'exports', 'require', '../toDate/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = isThursday;

    var _index = _interopRequireDefault(require("../toDate/index"));

    var _index2 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name isThursday
     * @category Weekday Helpers
     * @summary Is the given date Thursday?
     *
     * @description
     * Is the given date Thursday?
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the date to check
     * @returns {Boolean} the date is Thursday
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // Is 25 September 2014 Thursday?
     * var result = isThursday(new Date(2014, 8, 25))
     * //=> true
     */
    function isThursday(dirtyDate) {
      (0, _index2.default)(1, arguments);
      return (0, _index.default)(dirtyDate).getDay() === 4;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map