"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/isTomorrow/index", ['module', 'exports', 'require', '../addDays/index', '../isSameDay/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = isTomorrow;

    var _index = _interopRequireDefault(require("../addDays/index"));

    var _index2 = _interopRequireDefault(require("../isSameDay/index"));

    var _index3 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name isTomorrow
     * @category Day Helpers
     * @summary Is the given date tomorrow?
     * @pure false
     *
     * @description
     * Is the given date tomorrow?
     *
     * > ⚠️ Please note that this function is not present in the FP submodule as
     * > it uses `Date.now()` internally hence impure and can't be safely curried.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the date to check
     * @returns {Boolean} the date is tomorrow
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // If today is 6 October 2014, is 7 October 14:00:00 tomorrow?
     * var result = isTomorrow(new Date(2014, 9, 7, 14, 0))
     * //=> true
     */
    function isTomorrow(dirtyDate) {
      (0, _index3.default)(1, arguments);
      return (0, _index2.default)(dirtyDate, (0, _index.default)(Date.now(), 1));
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map