"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/isWeekend/index", ['module', 'exports', 'require', '../toDate/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = isWeekend;

    var _index = _interopRequireDefault(require("../toDate/index"));

    var _index2 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name isWeekend
     * @category Weekday Helpers
     * @summary Does the given date fall on a weekend?
     *
     * @description
     * Does the given date fall on a weekend?
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the date to check
     * @returns {Boolean} the date falls on a weekend
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // Does 5 October 2014 fall on a weekend?
     * var result = isWeekend(new Date(2014, 9, 5))
     * //=> true
     */
    function isWeekend(dirtyDate) {
      (0, _index2.default)(1, arguments);
      var date = (0, _index.default)(dirtyDate);
      var day = date.getDay();
      return day === 0 || day === 6;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map