"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/isYesterday/index", ['module', 'exports', 'require', '../isSameDay/index', '../subDays/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = isYesterday;

    var _index = _interopRequireDefault(require("../isSameDay/index"));

    var _index2 = _interopRequireDefault(require("../subDays/index"));

    var _index3 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name isYesterday
     * @category Day Helpers
     * @summary Is the given date yesterday?
     * @pure false
     *
     * @description
     * Is the given date yesterday?
     *
     * > ⚠️ Please note that this function is not present in the FP submodule as
     * > it uses `Date.now()` internally hence impure and can't be safely curried.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the date to check
     * @returns {Boolean} the date is yesterday
     * @throws {TypeError} 1 argument required
     *
     * @example
     * // If today is 6 October 2014, is 5 October 14:00:00 yesterday?
     * var result = isYesterday(new Date(2014, 9, 5, 14, 0))
     * //=> true
     */
    function isYesterday(dirtyDate) {
      (0, _index3.default)(1, arguments);
      return (0, _index.default)(dirtyDate, (0, _index2.default)(Date.now(), 1));
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map