"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/lastDayOfQuarter/index", ['module', 'exports', 'require', '../toDate/index', '../_lib/requiredArgs/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = lastDayOfQuarter;

    var _index = _interopRequireDefault(require("../toDate/index"));

    var _index2 = _interopRequireDefault(require("../_lib/requiredArgs/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * @name lastDayOfQuarter
     * @category Quarter Helpers
     * @summary Return the last day of a year quarter for the given date.
     *
     * @description
     * Return the last day of a year quarter for the given date.
     * The result will be in the local timezone.
     *
     * ### v2.0.0 breaking changes:
     *
     * - [Changes that are common for the whole library](https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#Common-Changes).
     *
     * @param {Date|Number} date - the original date
     * @param {Object} [options] - an object with options.
     * @param {0|1|2} [options.additionalDigits=2] - passed to `toDate`. See [toDate]{@link https://date-fns.org/docs/toDate}
     * @returns {Date} the last day of a quarter
     * @throws {TypeError} 1 argument required
     * @throws {RangeError} `options.additionalDigits` must be 0, 1 or 2
     *
     * @example
     * // The last day of a quarter for 2 September 2014 11:55:00:
     * var result = lastDayOfQuarter(new Date(2014, 8, 2, 11, 55, 0))
     * //=> Tue Sep 30 2014 00:00:00
     */
    function lastDayOfQuarter(dirtyDate) {
      (0, _index2.default)(1, arguments);
      var date = (0, _index.default)(dirtyDate);
      var currentMonth = date.getMonth();

      date.setMonth(currentMonth - currentMonth % 3 + 3, 0);
      date.setHours(0, 0, 0, 0);
      return date;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map