"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/locale/bn/_lib/match/index", ['module', 'exports', 'require', '../../../_lib/buildMatchPatternFn/index', '../../../_lib/buildMatchFn/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _index = _interopRequireDefault(require("../../../_lib/buildMatchPatternFn/index"));

    var _index2 = _interopRequireDefault(require("../../../_lib/buildMatchFn/index"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    var matchOrdinalNumberPattern = /^(\d+)(ম|য়|র্থ|ষ্ঠ|শে|ই|তম)?/i;
    var parseOrdinalNumberPattern = /\d+/i;
    var matchEraPatterns = {
      narrow: /^(খ্রিঃপূঃ|খ্রিঃ)/i,
      abbreviated: /^(খ্রিঃপূর্ব|খ্রিঃ)/i,
      wide: /^(খ্রিস্টপূর্ব|খ্রিস্টাব্দ)/i
    };
    var parseEraPatterns = {
      narrow: [/^খ্রিঃপূঃ/i, /^খ্রিঃ/i],
      abbreviated: [/^খ্রিঃপূর্ব/i, /^খ্রিঃ/i],
      wide: [/^খ্রিস্টপূর্ব/i, /^খ্রিস্টাব্দ/i]
    };
    var matchQuarterPatterns = {
      narrow: /^[১২৩৪]/i,
      abbreviated: /^[১২৩৪]ত্রৈ/i,
      wide: /^[১২৩৪](ম|য়|র্থ)? ত্রৈমাসিক/i
    };
    var parseQuarterPatterns = {
      any: [/১/i, /২/i, /৩/i, /৪/i]
    };
    var matchMonthPatterns = {
      narrow: /^(জানু|ফেব্রু|মার্চ|এপ্রিল|মে|জুন|জুলাই|আগস্ট|সেপ্ট|অক্টো|নভে|ডিসে)/i,
      abbreviated: /^(জানু|ফেব্রু|মার্চ|এপ্রিল|মে|জুন|জুলাই|আগস্ট|সেপ্ট|অক্টো|নভে|ডিসে)/i,
      wide: /^(জানুয়ারি|ফেব্রুয়ারি|মার্চ|এপ্রিল|মে|জুন|জুলাই|আগস্ট|সেপ্টেম্বর|অক্টোবর|নভেম্বর|ডিসেম্বর)/i
    };
    var parseMonthPatterns = {
      any: [/^জানু/i, /^ফেব্রু/i, /^মার্চ/i, /^এপ্রিল/i, /^মে/i, /^জুন/i, /^জুলাই/i, /^আগস্ট/i, /^সেপ্ট/i, /^অক্টো/i, /^নভে/i, /^ডিসে/i]
    };
    var matchDayPatterns = {
      narrow: /^(র|সো|ম|বু|বৃ|শু|শ)+/i,
      short: /^(রবি|সোম|মঙ্গল|বুধ|বৃহ|শুক্র|শনি)+/i,
      abbreviated: /^(রবি|সোম|মঙ্গল|বুধ|বৃহ|শুক্র|শনি)+/i,
      wide: /^(রবিবার|সোমবার|মঙ্গলবার|বুধবার|বৃহস্পতিবার |শুক্রবার|শনিবার)+/i
    };
    var parseDayPatterns = {
      narrow: [/^র/i, /^সো/i, /^ম/i, /^বু/i, /^বৃ/i, /^শু/i, /^শ/i],
      short: [/^রবি/i, /^সোম/i, /^মঙ্গল/i, /^বুধ/i, /^বৃহ/i, /^শুক্র/i, /^শনি/i],
      abbreviated: [/^রবি/i, /^সোম/i, /^মঙ্গল/i, /^বুধ/i, /^বৃহ/i, /^শুক্র/i, /^শনি/i],
      wide: [/^রবিবার/i, /^সোমবার/i, /^মঙ্গলবার/i, /^বুধবার/i, /^বৃহস্পতিবার /i, /^শুক্রবার/i, /^শনিবার/i]
    };
    var matchDayPeriodPatterns = {
      narrow: /^(পূ|অপ|মধ্যরাত|মধ্যাহ্ন|সকাল|বিকাল|সন্ধ্যা|রাত)/i,
      abbreviated: /^(পূর্বাহ্ন|অপরাহ্ন|মধ্যরাত|মধ্যাহ্ন|সকাল|বিকাল|সন্ধ্যা|রাত)/i,
      wide: /^(পূর্বাহ্ন|অপরাহ্ন|মধ্যরাত|মধ্যাহ্ন|সকাল|বিকাল|সন্ধ্যা|রাত)/i
    };
    var parseDayPeriodPatterns = {
      any: {
        am: /^পূ/i,
        pm: /^অপ/i,
        midnight: /^মধ্যরাত/i,
        noon: /^মধ্যাহ্ন/i,
        morning: /সকাল/i,
        afternoon: /বিকাল/i,
        evening: /সন্ধ্যা/i,
        night: /রাত/i
      }
    };
    var match = {
      ordinalNumber: (0, _index.default)({
        matchPattern: matchOrdinalNumberPattern,
        parsePattern: parseOrdinalNumberPattern,
        valueCallback: function (value) {
          return parseInt(value, 10);
        }
      }),
      era: (0, _index2.default)({
        matchPatterns: matchEraPatterns,
        defaultMatchWidth: 'wide',
        parsePatterns: parseEraPatterns,
        defaultParseWidth: 'any'
      }),
      quarter: (0, _index2.default)({
        matchPatterns: matchQuarterPatterns,
        defaultMatchWidth: 'wide',
        parsePatterns: parseQuarterPatterns,
        defaultParseWidth: 'any',
        valueCallback: function (index) {
          return index + 1;
        }
      }),
      month: (0, _index2.default)({
        matchPatterns: matchMonthPatterns,
        defaultMatchWidth: 'wide',
        parsePatterns: parseMonthPatterns,
        defaultParseWidth: 'any'
      }),
      day: (0, _index2.default)({
        matchPatterns: matchDayPatterns,
        defaultMatchWidth: 'wide',
        parsePatterns: parseDayPatterns,
        defaultParseWidth: 'any'
      }),
      dayPeriod: (0, _index2.default)({
        matchPatterns: matchDayPeriodPatterns,
        defaultMatchWidth: 'any',
        parsePatterns: parseDayPeriodPatterns,
        defaultParseWidth: 'any'
      })
    };
    var _default = match;
    exports.default = _default;
    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map