"use strict";

Liferay.Loader.define("change-tracking-web$date-fns@2.14.0/locale/en-CA/_lib/formatDistance/index", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = formatDistance;
    var formatDistanceLocale = {
      lessThanXSeconds: {
        one: 'less than a second',
        other: 'less than {{count}} seconds'
      },
      xSeconds: {
        one: 'a second',
        other: '{{count}} seconds'
      },
      halfAMinute: 'half a minute',
      lessThanXMinutes: {
        one: 'less than a minute',
        other: 'less than {{count}} minutes'
      },
      xMinutes: {
        one: 'a minute',
        other: '{{count}} minutes'
      },
      aboutXHours: {
        one: 'about an hour',
        other: 'about {{count}} hours'
      },
      xHours: {
        one: 'an hour',
        other: '{{count}} hours'
      },
      xDays: {
        one: 'a day',
        other: '{{count}} days'
      },
      aboutXWeeks: {
        one: 'about a week',
        other: 'about {{count}} weeks'
      },
      xWeeks: {
        one: 'a week',
        other: '{{count}} weeks'
      },
      aboutXMonths: {
        one: 'about a month',
        other: 'about {{count}} months'
      },
      xMonths: {
        one: 'a month',
        other: '{{count}} months'
      },
      aboutXYears: {
        one: 'about a year',
        other: 'about {{count}} years'
      },
      xYears: {
        one: 'a year',
        other: '{{count}} years'
      },
      overXYears: {
        one: 'over a year',
        other: 'over {{count}} years'
      },
      almostXYears: {
        one: 'almost a year',
        other: 'almost {{count}} years'
      }
    };

    function formatDistance(token, count, options) {
      options = options || {};
      var result;

      if (typeof formatDistanceLocale[token] === 'string') {
        result = formatDistanceLocale[token];
      } else if (count === 1) {
        result = formatDistanceLocale[token].one;
      } else {
        result = formatDistanceLocale[token].other.replace('{{count}}', count);
      }

      if (options.addSuffix) {
        if (options.comparison > 0) {
          return 'in ' + result;
        } else {
          return result + ' ago';
        }
      }

      return result;
    }

    module.exports = exports.default;
  }
});
//# sourceMappingURL=index.js.map